<?php
/** 
 * Plugin Name: langly
 * Plugin URI: 
 * Description: Adds a customizable Google Translate dropdown with multiple style options (minimal, modern). Shortcode: [langly_dropdown]
 * Version: 1.0.1
 * Author: Shubham 
 * Author URI: https://vikral.netlify.app/
 * License: GPLv2 or later
 * Text Domain: langly
 * Domain Path: /languages
 */


if (!defined('ABSPATH'))
    exit;

function langly_get_languages()
{
    return [
        'ab|ab' => 'Abkhaz',
        'ace|ace' => 'Acehnese',
        'ach|ach' => 'Acholi',
        'af|af' => 'Afrikaans',
        'ak|ak' => 'Akan',
        'am|am' => 'Amharic',
        'ar|ar' => 'Arabic',
        'as|as' => 'Assamese',
        'awa|awa' => 'Awadhi',
        'ay|ay' => 'Aymara',
        'az|az' => 'Azerbaijani',
        'ba|ba' => 'Bashkir',
        'be|be' => 'Belarusian',
        'bem|bem' => 'Bemba',
        'bn|bn' => 'Bengali',
        'bew|bew' => 'Betawi',
        'bho|bho' => 'Bhojpuri',
        'bik|bik' => 'Bikol',
        'bs|bs' => 'Bosnian',
        'br|br' => 'Breton',
        'bg|bg' => 'Bulgarian',
        'bua|bua' => 'Buryat',
        'my|my' => 'Burmese',
        'ca|ca' => 'Catalan',
        'ceb|ceb' => 'Cebuano',
        'ny|ny' => 'Chichewa',
        'zh-CN|zh-CN' => 'Chinese (Simplified)',
        'zh-TW|zh-TW' => 'Chinese (Traditional)',
        'cv|cv' => 'Chuvash',
        'co|co' => 'Corsican',
        'crh|crh' => 'Crimean Tatar',
        'cs|cs' => 'Czech',
        'da|da' => 'Danish',
        'nl|nl' => 'Dutch',
        'en|en' => 'English',
        'eo|eo' => 'Esperanto',
        'et|et' => 'Estonian',
        'eu|eu' => 'Basque',
        'ff|ff' => 'Fula',
        'fi|fi' => 'Finnish',
        'fr|fr' => 'French',
        'fy|fy' => 'Frisian',
        'gl|gl' => 'Galician',
        'ka|ka' => 'Georgian',
        'de|de' => 'German',
        'el|el' => 'Greek',
        'gu|gu' => 'Gujarati',
        'ht|ht' => 'Haitian Creole',
        'ha|ha' => 'Hausa',
        'haw|haw' => 'Hawaiian',
        'he|he' => 'Hebrew',
        'hi|hi' => 'Hindi',
        'hmn|hmn' => 'Hmong',
        'hr|hr' => 'Croatian',
        'hu|hu' => 'Hungarian',
        'hy|hy' => 'Armenian',
        'id|id' => 'Indonesian',
        'ig|ig' => 'Igbo',
        'ilo|ilo' => 'Ilocano',
        'is|is' => 'Icelandic',
        'it|it' => 'Italian',
        'ja|ja' => 'Japanese',
        'jw|jw' => 'Javanese',
        'kn|kn' => 'Kannada',
        'kk|kk' => 'Kazakh',
        'km|km' => 'Khmer',
        'ko|ko' => 'Korean',
        'ku|ku' => 'Kurdish',
        'ky|ky' => 'Kyrgyz',
        'lo|lo' => 'Lao',
        'la|la' => 'Latin',
        'lv|lv' => 'Latvian',
        'lt|lt' => 'Lithuanian',
        'lb|lb' => 'Luxembourgish',
        'mk|mk' => 'Macedonian',
        'mg|mg' => 'Malagasy',
        'ms|ms' => 'Malay',
        'ml|ml' => 'Malayalam',
        'mt|mt' => 'Maltese',
        'mi|mi' => 'Maori',
        'mr|mr' => 'Marathi',
        'mhr|mhr' => 'Meadow Mari',
        'mri|mri' => 'Hill Mari',
        'mn|mn' => 'Mongolian',
        'myv|myv' => 'Erzya',
        'ne|ne' => 'Nepali',
        'no|no' => 'Norwegian',
        'oc|oc' => 'Occitan',
        'or|or' => 'Odia (Oriya)',
        'om|om' => 'Oromo',
        'ps|ps' => 'Pashto',
        'fa|fa' => 'Persian',
        'pl|pl' => 'Polish',
        'pt|pt' => 'Portuguese',
        'pa|pa' => 'Punjabi',
        'ro|ro' => 'Romanian',
        'ru|ru' => 'Russian',
        'sm|sm' => 'Samoan',
        'sa|sa' => 'Sanskrit',
        'gd|gd' => 'Scottish Gaelic',
        'sr|sr' => 'Serbian',
        'sh|sh' => 'Serbo-Croatian',
        'sn|sn' => 'Shona',
        'sd|sd' => 'Sindhi',
        'si|si' => 'Sinhala',
        'sk|sk' => 'Slovak',
        'sl|sl' => 'Slovenian',
        'so|so' => 'Somali',
        'st|st' => 'Southern Sotho',
        'es|es' => 'Spanish',
        'su|su' => 'Sundanese',
        'sw|sw' => 'Swahili',
        'sv|sv' => 'Swedish',
        'tg|tg' => 'Tajik',
        'ta|ta' => 'Tamil',
        'te|te' => 'Telugu',
        'th|th' => 'Thai',
        'ti|ti' => 'Tigrinya',
        'to|to' => 'Tonga',
        'ts|ts' => 'Tsonga',
        'tr|tr' => 'Turkish',
        'tk|tk' => 'Turkmen',
        'uk|uk' => 'Ukrainian',
        'ur|ur' => 'Urdu',
        'uz|uz' => 'Uzbek',
        'vi|vi' => 'Vietnamese',
        'cy|cy' => 'Welsh',
        'xh|xh' => 'Xhosa',
        'yi|yi' => 'Yiddish',
        'yo|yo' => 'Yoruba',
        'zu|zu' => 'Zulu',
    ];
}

// script and style
function langly_enqueue_scripts()
{

    wp_enqueue_style(
        'langly-dropdown-style',
        plugin_dir_url(__FILE__) . 'style.css',
        [],
        '1.0',
        'all'
    );



    wp_enqueue_script(
        'translate-library',
        '//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit',
        [],
        '1.0',
        true
    );

    wp_enqueue_script(
        'langly-custom-script',
        plugin_dir_url(__FILE__) . 'langly.js',
        ['translate-library'],
        '1.0',
        true
    );
}
add_action('wp_enqueue_scripts', 'langly_enqueue_scripts');
add_action('wp_footer', 'langly_enqueue_footer_scripts', 9999); 

// the settings page
function langly_settings_page()
{
    add_menu_page(
        'Langly Settings',
        'Langly',
        'manage_options',
        'langly-settings',
        'langly_settings_page_content',
        plugin_dir_url(__FILE__) . 'translate.png',
        100
    );
}
add_action('wp_enqueue_scripts', 'langly_enqueue_scripts');
add_action('wp_footer', 'langly_enqueue_footer_scripts', 9999);

// Settings page content
function langly_settings_page_content()
{
    $all_languages = langly_get_languages();
    $selected_languages = get_option('langly_languages', []);

    if (!is_array($selected_languages)) {
        $selected_languages = [];
    }
    ?>
    <div class="wrap">
        <h1>Langly Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('langly_settings_group');
            do_settings_sections('langly-settings');
            ?>
            <table class="form-table">
                <!-- Language DD -->
                <tr valign="top">
                    <th scope="row">Select Languages</th>
                    <td>
                        <select name="langly_languages[]" multiple style="width: 100%; height: 200px;">
                            <?php foreach ($all_languages as $code => $name): ?>
                                <option value="<?php echo esc_attr($code); ?>" <?php echo in_array($code, $selected_languages) ? 'selected' : ''; ?>>
                                    <?php echo esc_html($name); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <p>Hold down the "Ctrl" (Windows) or "Cmd" (Mac) key to select multiple languages.<br> Shortcode:
                            [langly_dropdown]</p>
                    </td>
                </tr>

                <!-- Selected lang view  -->
                <tr valign="top">
                    <th scope="row">Selected Languages</th>
                    <td>
                        <?php if (!empty($selected_languages)): ?>
                            <table style="width: 100%; border-collapse: collapse; border: 1px solid #ccc;">
                                <thead>
                                    <tr>
                                        <th style="border: 1px solid #ccc; padding: 8px;">Language Code</th>
                                        <th style="border: 1px solid #ccc; padding: 8px;">Language Name</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($selected_languages as $code): ?>
                                        <?php if (isset($all_languages[$code])): ?>
                                            <tr>
                                                <td style="border: 1px solid #ccc; padding: 8px;"><?php echo esc_html($code); ?></td>
                                                <td style="border: 1px solid #ccc; padding: 8px;">
                                                    <?php echo esc_html($all_languages[$code]); ?>
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        <?php else: ?>
                            <p>No languages selected.</p>
                        <?php endif; ?>
                    </td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

/**
 * Register and sanitize settings
 */
function langly_register_settings()
{
    register_setting(
        'langly_settings_group',
        'langly_languages',
        array(
            'type' => 'array',
            'sanitize_callback' => 'langly_sanitize_languages',
            'default' => array('en|en')
        )
    );
}
add_action('admin_init', 'langly_register_settings');

/**
 * @param array $input 
 * @return array 
 */
function langly_sanitize_languages($input)
{
    if (!is_array($input)) {
        return array();
    }

    $valid_languages = array_keys(langly_get_languages());
    $sanitized = array();

    foreach ($input as $lang_code) {
        if (in_array($lang_code, $valid_languages)) {
            $sanitized[] = sanitize_text_field($lang_code);
        }
    }

    return !empty($sanitized) ? $sanitized : array('en|en');
}

function langly_activate()
{
    if (get_option('langly_languages') === false) {
        add_option('langly_languages', ['en|en']);
    }
}
register_activation_hook(__FILE__, 'langly_activate');

// adds shortcode
function langly_shortcode()
{
    $selected_languages = get_option('langly_languages', []);
    $all_languages = langly_get_languages();

    if (empty($selected_languages)) {
        $selected_languages = ['en|en'];
    }

    ob_start();
    ?>
    <div id="google_translate_element" style="display: none;"></div>

    <!-- Dropdown for language selection -->
    <div class="custom-dropdown" id="languageDropdown">
        <span class="language-header" onclick="toggleDropdown()">
            <span id="selected-language">English</span>
            <i id="dropdown-arrow" class="arrow"></i>
        </span>
        <div class="dropdown-menu" id="customDropdownMenu">
            <?php foreach ($selected_languages as $code): ?>
                <?php if (isset($all_languages[$code])): ?>
                    <a class="dropdown-item" href="javascript:void(0)"
                        onclick="changeLanguage('<?php echo esc_html($all_languages[$code]); ?>', '<?php echo esc_html($code); ?>')">
                        <?php echo esc_html($all_languages[$code]); ?>
                    </a>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('langly_dropdown', 'langly_shortcode');