function googleTranslateElementInit() {
  new google.translate.TranslateElement({}, "google_translate_element");
}

function langlyTranslate(langPair) {
  if (!langPair || !langPair.includes("|")) return;

  const toLang = langPair.split("|")[1];
  const translateCombo = document.querySelector(".goog-te-combo");

  if (translateCombo) {
    translateCombo.value = "";
    translateCombo.dispatchEvent(new Event("change"));

    setTimeout(() => {
      translateCombo.value = toLang;
      translateCombo.dispatchEvent(new Event("change"));
    }, 100);
  } else {
    console.error("Translation dropdown not found.");
  }
}

function sanitizeInput(input) {
  const element = document.createElement("div");
  element.textContent = input;
  return element.innerHTML;
}

window.changeLanguage = function (language, langPair) {
  const safeLanguage = sanitizeInput(language);
  const selectedLanguageEl = document.getElementById("selected-language");
  

  if (selectedLanguageEl) {
    selectedLanguageEl.textContent = safeLanguage;
  }
  langlyTranslate(langPair);
};


function toggleDropdown() {
  const menu = document.getElementById('customDropdownMenu');
  const arrow = document.getElementById('dropdown-arrow');
  menu.classList.toggle('show');
  arrow.style.transform = menu.classList.contains('show') ? 'rotate(-135deg)' : 'rotate(45deg)';
}

document.addEventListener('click', function (e) {
  const dropdown = document.getElementById('languageDropdown');
  const menu = document.getElementById('customDropdownMenu');
  const arrow = document.getElementById('dropdown-arrow');
  if (!dropdown.contains(e.target)) {
      menu.classList.remove('show');
      arrow.style.transform = 'rotate(45deg)';
  }
});

