<?php

namespace LadderSEO;

/**
 * The file that defines the webmaster plugin logics
 *
 *
 * @link       https://digitaldreamstech.com
 * @since      1.0.0
 *
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/src
 */


class Webmaster extends Core
{
    public function __construct()
    {
        parent::__construct();
    }
    
    public function add_actions()
    {
        add_action( 'wp_head', [ $this, 'add_meta_tag' ] );
    }

    public function add_meta_tag(){
        $meta_tags = "";
        $settings = get_option(LADDER_SEO_SETTINGS);
        $webmaster_fields = isset($settings["webmaster"])? $settings["webmaster"]: array();
        foreach($webmaster_fields as $field_name => $content) { 
            $this->ouput_meta_tag($field_name, $content);
        }
        
    }

    private function ouput_meta_tag($prop_id, $tag){
        $meta_tag = "";        
        if ( $tag ) {
            $name = $this->get_meta_name($prop_id);
			$meta_tag = '<meta name="'.esc_html($name).'" content="'.esc_attr( $tag ).'">';
            echo $meta_tag;// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		}
    }

    private function get_meta_name($id){
        $meta_tags["google"] = "google-site-verification";
        $meta_tags["bing"] = "msvalidate.01";
        $meta_tags["baidu"] = "baidu-site-verification";
        $meta_tags["yandex"] = "yandex-verification";
        $meta_tags["pinterest"] = "p:domain_verify";

        return $meta_tags[$id];
    }

}
