<?php

namespace LadderSEO;

/**
 * The file that defines the w3c plugin logics
 *
 *
 * @link       https://digitaldreamstech.com
 * @since      1.0.0
 *
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/src
 */


class W3C extends Core
{
    public function __construct()
    {
        parent::__construct();
    }

    public function add_actions()
    {
        add_action('shutdown', [$this, 'validate_doctype_output'], 0);
        add_action('template_redirect', [$this, 'start_output_buffering'], 0);
    }

    public function start_output_buffering()
    {
        ob_start(function ($content) {
            return $this->remove_duplicate_attributes($content);
        });
    }

    public function remove_duplicate_attributes($html)
    {
        // Match all elements with potential duplicate attributes
        return preg_replace_callback('/<([a-z]+)([^>]*)>/i', function ($matches) {
            $tag = $matches[1];
            $attributes = $matches[2];

            // Parse attributes and remove duplicates
            preg_match_all('/([a-z-]+)="([^"]*)"/i', $attributes, $attr_matches, PREG_SET_ORDER);
            $unique_attrs = [];
            foreach ($attr_matches as $attr) {
                $unique_attrs[$attr[1]] = $attr[0]; // Use attribute name as the key
            }

            // Rebuild the element with unique attributes
            $unique_attributes_string = implode(' ', $unique_attrs);
            return "<{$tag} {$unique_attributes_string}>";
        }, $html);
    }

    public function validate_doctype_output()
    {
        $output = ob_get_clean();
        if (stripos($output, '<!DOCTYPE html>') === false) {
            $output = '<!DOCTYPE html>' . $output;
        }
        echo $output;// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    }

}
