<?php

namespace LadderSEO;

/**
 * The file that defines the twitter_cards plugin logics
 *
 *
 * @link       https://digitaldreamstech.com
 * @since      1.0.0
 *
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/src
 */


class Twitter_Cards extends Core
{
    public function __construct()
    {
        parent::__construct();
    }


    public function get_og_properties()
    {
        $twitter_tags = [
            'twitter:title' => $this->get_title(),
            'twitter:card'  => 'summary_large_image',
            'twitter:image' => $this->get_image(),
            'twitter:description'  => $this->get_description(),
            'twitter:site'    => $this->get_site_name(),
            'twitter:creator' => $this->get_creator(),
        ];
        return $twitter_tags;
    }

    public function add_actions()
    {
        add_action('wp_head', [ $this, 'twitter_cards_output' ]);
    }

    public function twitter_cards_output(){
        $twitter_tags = $this->get_og_properties();
        foreach ($twitter_tags as $property => $content) {
            if (!empty($content)) { // Ensure no empty tags are output
                echo '<meta property="' . esc_attr($property) . '" content="' . esc_attr($content) . '">' . "\n";
            }
        }
    }

    // Retrieves the title of the current page or post
    public function get_title()
    {
        return wp_get_document_title();
    }


    // Retrieves the featured image URL for the current post
    public function get_image()
    {
        if (has_post_thumbnail()) {
            return get_the_post_thumbnail_url(get_the_ID(), 'full');
        }
        return ''; // Default or fallback image URL can be set here
    }

    // Retrieves the description of the current page or post
    public function get_description()
    {
        if (is_singular()) {
            global $post;
            $description = get_the_excerpt($post);
            if (!$description) {
                $description = wp_trim_words(strip_shortcodes($post->post_content), 30, '...');
            }
            return $description;
        }
        return get_bloginfo('description'); // Fallback to site description
    }

    // Retrieves the site name for the Twitter `site` tag
    public function get_site_name() {
        $twitter_handle = get_option('twitter_site_handle', ''); // Example: Use an option to store the handle
        if (!empty($twitter_handle)) {
            return '@' . ltrim($twitter_handle, '@');
        }
        return ''; // Return an empty string if no handle is available
    }

    // Retrieves the creator's Twitter handle
    public function get_creator() {
        if (is_singular()) {
            $author_id = get_post_field('post_author', get_the_ID());
            $twitter_handle = get_user_meta($author_id, 'twitter', true); // Example: Store the handle in user meta
            if (!empty($twitter_handle)) {
                return '@' . ltrim($twitter_handle, '@');
            }
        }
        return ''; // Return an empty string if no handle is available
    }
}