<?php
namespace LadderSEO;
/**
 * The file that defines the redirection plugin functions
 *
 *
 * @link       https://digitaldreamstech.com
 * @since      1.0.0
 *
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/src
 */

class Redirection  extends Core{

	/**
	 * Define the redirection functionality of the plugin.
	 *
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		parent::__construct();
	}

	public function add_actions()
    {
        add_action( 'template_redirect', [ $this, 'add_redirection']);
		add_action( 'template_redirect', [ $this, 'add_404_logs']);
    }

	public function add_redirection(){
		if (is_admin()) return;
		$db_manager = new DB_Manager();
		$current_url = isset($_SERVER['REQUEST_URI']) ? esc_url_raw($_SERVER['REQUEST_URI']) : '';
		$result = $db_manager->get_data_redirection_by_url($current_url);	
		if ($result) {
			wp_safe_redirect($result["target_url"], $result["redirect_type"]);
			exit;
		}
	}

	public function add_404_logs(){
		if (is_404()) {
			$url = isset($_SERVER['REQUEST_URI']) ? esc_url_raw($_SERVER['REQUEST_URI']) : '';
			$referrer = isset($_SERVER['HTTP_REFERER']) ? esc_url_raw($_SERVER['HTTP_REFERER']) : '';
			$db_manager = new DB_Manager();
			$data["source_url"] = $url;
			$data["referrer"] = $referrer;
			$data["hits"] = 1;
			$data["last_accessed"] = date("Y-m-d h:i:s");
			$db_manager->save_data_404_log($data);
		}
	}
}