<?php
namespace LadderSEO;
/**
 * The file that defines the optimization plugin functions
 *
 *
 * @link       https://digitaldreamstech.com
 * @since      1.0.0
 *
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/src
 */

class Optimization  extends Core{

	/**
	 * Define the optimization functionality of the plugin.
	 *
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
        add_action('init', [$this, 'add_actions']);
	}

	public function add_actions()
    {
        $settings = get_option(LADDER_SEO_SETTINGS);
        $opt_settings = isset($settings["optimization"]) ? $settings["optimization"] : array();

        if(isset($opt_settings["shortlinks"]) && $opt_settings["shortlinks"])
            remove_action('wp_head', 'wp_shortlink_wp_head', 10, 0);

        if(isset($opt_settings["rest_api"]) && $opt_settings["rest_api"])
            remove_action('wp_head', 'rest_output_link_wp_head', 10);
        
        if(isset($opt_settings["generator_tag"]) && $opt_settings["generator_tag"])
            remove_action('wp_head', 'wp_generator');//wp generator

        if(isset($opt_settings["external_system"]) && $opt_settings["external_system"])
        {
            remove_action('wp_head', 'rsd_link'); // Removes RSD link
            remove_action('wp_head', 'wlwmanifest_link'); // Removes Windows Live Writer link
        }
            
        if(isset($opt_settings["ping_httpheader"]) && $opt_settings["ping_httpheader"])
        {
            add_filter('wp_headers', [$this, 'remove_pingback_header']);
            add_filter('bloginfo_url', [$this,'remove_pingback_url'], 10, 2);
            add_filter('xmlrpc_enabled', '__return_false'); 
        }
        
        if(isset($opt_settings["powered_httpheader"]) && $opt_settings["powered_httpheader"])
            header_remove('X-Powered-By');
    }

    public function remove_pingback_header($headers){
        unset($headers['X-Pingback']); // Removes the X-Pingback header
        return $headers;
    }

    function remove_pingback_url($output, $show) {
        if ($show === 'pingback_url') {
            return '';
        }
        return $output;
    }
}