<?php

namespace LadderSEO;

/**
 * The file that defines the meta_title plugin logics
 *
 *
 * @link       https://digitaldreamstech.com
 * @since      1.0.0
 *
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/src
 */


class Meta_Title extends Core
{
    public function __construct()
    {
        parent::__construct();
    }


    public function add_actions()
    {
        add_action('after_setup_theme',[$this, 'add_title_support']);        
        add_filter('pre_get_document_title', [ $this, 'get_title' ]);
        add_filter('post_type_archive_title', [ $this, 'archive_title' ]);
    }

    public function add_title_support(){
        add_theme_support( 'title-tag' );
    }

    public function get_title($title)
    {
        $generated_title = $this->ladderseo_generate_dynamic_data("meta_title");
        $title = !empty($generated_title) ? $generated_title : $title;
        return $title;
    }

    public function archive_title($title)
    {
        $generated_title = $this->ladderseo_generate_dynamic_data("meta_title");
        $title = !empty($generated_title) ? $generated_title : $title;
        return $title;
    }
}