<?php

namespace LadderSEO;

/**
 * The file that defines the meta_description plugin logics
 *
 *
 * @link       https://digitaldreamstech.com
 * @since      1.0.0
 *
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/src
 */


class Meta_Description extends Core
{
    public function __construct()
    {
        parent::__construct();
    }


    public function add_actions()
    {
        add_post_type_support( 'page', 'excerpt' );
        add_action( 'wp_head', [ $this, 'post_description' ] );
    }

    public function post_description(){

        $generated_description = $this->ladderseo_generate_dynamic_data("meta_description");
        $description = !empty($generated_description) ? $generated_description : "";
        $this->ouput_meta_tag($description);       
    }

    private function ouput_meta_tag($description){
        if ( $description ) {
			echo '<meta name="description" content="', esc_attr( $description ), '">', "\n";
		}
    }

}
