<?php

namespace LadderSEO;

/**
 * The file that defines the image_seo plugin logics
 *
 *
 * @link       https://digitaldreamstech.com
 * @since      1.0.0
 *
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/src
 */


class Image_SEO extends Core
{
    public function __construct()
    {
        parent::__construct();
    }


    public function add_actions()
    {
		add_filter( 'wp_get_attachment_image_attributes', [ $this, 'add_image_attribute' ], 10, 2 );
		add_filter( 'wp_prepare_attachment_for_js', [ $this, 'add_image_attribute' ], 10, 2 );
		add_action( 'add_attachment', [ $this, 'generate_meta_data_on_upload' ] );
    }

    public function add_image_attribute($attributes, $attachment) {
         // if attachment is empty, return attributes
        if ( empty( $attachment ) ) {
			return $attributes;
		}
        // Check if 'alt' attribute is empty
        if (empty($attributes['alt'])) {
            $image_name = get_the_title($attachment->ID);
            $formatted_alt = $this->ladderseo_normalize($image_name);
            $attributes['alt'] = $formatted_alt;
        }
    
        return $attributes;
    }

    public function generate_meta_data_on_upload( $post_id ){
		  // Get the attachment's post type
          $post = get_post($post_id);
          if ($post->post_type !== 'attachment') {
              return;
          }
      
          $file_path = get_attached_file($post_id); // Full file path
          $file_name = pathinfo($file_path, PATHINFO_FILENAME); // Extract file name without extension      
          $alt_text = $this->ladderseo_normalize($file_name);
          update_post_meta($post_id, '_wp_attachment_image_alt', $alt_text);
	}
}