<?php
namespace LadderSEO;
/**
 * The file that defines the db related functionality
 *
 *
 * @link       https://digitaldreamstech.com
 * @since      1.0.0
 *
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/src
 */

class DB_Manager {

	/**
	 * Define the base functionality of the plugin.
	 *
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		
	}

    public function install_dbs(){
        $this->install_db_redirection();
        $this->install_db_404_logs();
    }

    /**
     *  Install DB tables for redirection
     *
     * @return mixed|void
     * @since    1.0.0
     * @access   public
     */
    public function install_db_redirection()
    {
        global $wpdb;
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        $sql = $this->get_redirection_table_sql();
        dbDelta($sql);        
    }

    /**
     *  Install DB tables for 404 logs
     *
     * @return mixed|void
     * @since    1.0.0
     * @access   public
     */
    public function install_db_404_logs()
    {
        global $wpdb;
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        $sql = $this->get_404_logs_table_sql();
        dbDelta($sql);        
    }

    private function get_redirection_table_sql(){
        $table_name     = \Ladder_SEO_Util::get_redirection_table_name();
        $collate        = \Ladder_SEO_Util::get_collate();

        $sql = "CREATE TABLE $table_name (
				id                 INT UNSIGNED NOT NULL AUTO_INCREMENT,
				source_url         VARCHAR(199) NOT NULL,
				target_url         VARCHAR(199) NOT NULL,
                redirect_type      VARCHAR(100) NOT NULL,
                PRIMARY KEY  (id)
                ) ENGINE=InnoDB ROW_FORMAT=DYNAMIC $collate;";

        return $sql;
    }

    private function get_404_logs_table_sql(){
        $table_name     = \Ladder_SEO_Util::get_404_logs_table_name();
        $collate        = \Ladder_SEO_Util::get_collate();

        $sql = "CREATE TABLE $table_name (
				id                 INT UNSIGNED NOT NULL AUTO_INCREMENT,
				source_url         VARCHAR(199) NOT NULL,
                referrer           VARCHAR(199) NOT NULL,
                hits               bigint(20) NOT NULL,
				last_accessed      DATETIME,
                PRIMARY KEY  (id)
                ) ENGINE=InnoDB ROW_FORMAT=DYNAMIC $collate;";

        return $sql;
    }

    public function insert_data_redirection($data){
        global $wpdb;
        $table_name     = \Ladder_SEO_Util::get_redirection_table_name();
        $insert_id = $wpdb->insert(
            $table_name,
            $data,
            array(
            '%s',
            '%s',
            '%s',
            )
        );
        if ($insert_id) {
            $response = array( 'success' => true, "insert_id" => $insert_id );
            return wp_send_json_success($response);
        }
        else{
            $response = array( 'success' => false );
            return wp_send_json_error($response);
        }
    }

    public function save_data_404_log($data)
    {
        $url = isset($data["source_url"])? $data["source_url"] : "";
        if($url){
            $results = $this->get_data_404_logs_by_url($url);
            if($results){ //update
                $this->update_data_404_log($data, $results);
            }
            else{
                $this->insert_data_404_log($data);
            }
        }
    }


    public function insert_data_404_log($data){
        global $wpdb;
        $table_name     = \Ladder_SEO_Util::get_404_logs_table_name();
        $insert_id = $wpdb->insert(
            $table_name,
            $data,
            array(
            '%s',
            '%s',
            '%d',
            '%s',
            )
        );
    }

    public function update_data_404_log($data, $results){
        global $wpdb;
        $table_name     = \Ladder_SEO_Util::get_404_logs_table_name();
        $wpdb->update(
            $table_name,
            ['hits' => $results["hits"] + 1],
            ['id' => $results["id"]],
            ['%d'],
            ['%d']
        );
    }

    public function get_data_redirection(){
        global $wpdb;
        $table_name     = \Ladder_SEO_Util::get_redirection_table_name();
        $table_name = esc_sql( $table_name );
        // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared -- dynamic table name is manually escaped
        $results = $wpdb->get_results("SELECT * FROM $table_name", ARRAY_A);
        return $results;
    }

    public function get_data_redirection_by_url($url){
        global $wpdb;
        $table_name     = \Ladder_SEO_Util::get_redirection_table_name();
        $table_name = esc_sql( $table_name );
        // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared -- dynamic table name is manually escaped
        $results = $wpdb->get_row($wpdb->prepare("SELECT * FROM `$table_name` where source_url = %s", $url), ARRAY_A);
        return $results;
    }

    public function get_data_404_logs(){
        global $wpdb;
        $table_name     = \Ladder_SEO_Util::get_404_logs_table_name();
        $table_name = esc_sql( $table_name );

        // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared -- dynamic table name is manually escaped
        $results = $wpdb->get_results("SELECT * FROM `$table_name`", ARRAY_A);
        return $results;
    }

    public function get_data_404_logs_by_url($url){
        global $wpdb;
        $table_name     = \Ladder_SEO_Util::get_404_logs_table_name();
        $table_name = esc_sql( $table_name );
        // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared -- dynamic table name is manually escaped
        $results = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name where source_url = %s",  $url), ARRAY_A);
        return $results;
    }

    public function delete_data_redirection($id){
        global $wpdb;
        $where = array("id" => $id);
        $table_name     = \Ladder_SEO_Util::get_redirection_table_name();
        $delete_rows = $wpdb->delete(
            $table_name,
            $where,
            array(
            '%d',
            )
        );

        if ($delete_rows) {
            $response = array( 'success' => true );
            return wp_send_json_success($response);
        }else{
            $response = array( 'success' => false );
            return wp_send_json_error($response);
        }
    }

    public function delete_data_404_logs(){
        global $wpdb;
        $table_name     = \Ladder_SEO_Util::get_404_logs_table_name();
        $delete_rows = $wpdb->delete(
            $table_name
        );

        if ($delete_rows) {
            $response = array( 'success' => true );
            return wp_send_json_success($response);
        }else{
            $response = array( 'success' => false );
            return wp_send_json_error($response);
        }
    }
}