<?php

namespace LadderSEO;

/**
 * The file that defines the canonical_url plugin logics
 *
 *
 * @link       https://digitaldreamstech.com
 * @since      1.0.0
 *
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/src
 */


class Canonical_URL extends Core
{
    public function __construct()
    {
        parent::__construct();
    }


    public function add_actions()
    {
        add_action('wp_head', [$this, 'add_canonical_url'], 1); // High priority to override default WP canonical.
        remove_action('wp_head', 'rel_canonical'); // Prevents WP from adding its own canonical.
    }

    /**
     * Output custom canonical URL if set in post meta.
     */
    public function add_canonical_url() {
        if (is_singular()) {
            $post_id = get_queried_object_id();
            $post_type = get_post_type($post_id);
            $canonical_url = get_post_meta($post_id, 'ladderseo_'.$post_type.'-canonical', true);

            if (!empty($canonical_url) && filter_var($canonical_url, FILTER_VALIDATE_URL)) {
                echo '<link rel="canonical" href="' . esc_url($canonical_url) . '" />' . "\n";
            } else {
                // Fallback: Use default permalink if no custom canonical URL is set.
                echo '<link rel="canonical" href="' . esc_url(get_permalink($post_id)) . '" />' . "\n";
            }
        }
    }
}