<?php

namespace LadderSEO;

/**
 * The file that defines the base plugin functions
 *
 *
 * @link       https://digitaldreamstech.com
 * @since      1.0.0
 *
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/src
 */

class Base
{
    /**
     * Define the base functionality of the plugin.
     *
     *
     * @since    1.0.0
     */
    public function __construct()
    {

    }

    public function run()
    {
        $settings = get_option(LADDER_SEO_SETTINGS);
        $fields = isset($settings["general"]) ? $settings["general"] : array();

        if ($this->check_field("meta_tags", $settings)) {
            $meta_title = new Meta_Title();
            $meta_title->add_actions();
        }

        if ($this->check_field("meta_description", $settings)) {
            $meta_description = new Meta_Description();
            $meta_description->add_actions();
        }

        if ($this->check_field("meta_robots", $settings)) {
            $meta_robots = new Meta_Robots();
            $meta_robots->add_actions();
        }

        if ($this->check_field("image_title", $settings)) {
            $image_seo = new image_SEO();
            $image_seo->add_actions();
        }

        if ($this->check_field("schema", $settings)) {
            $schema = new Schema();
            $schema->add_actions();
        }

        if ($this->check_field("canonical_url", $settings)) {
            $canonical_URL = new Canonical_URL();
            $canonical_URL->add_actions();
        }

        if ($this->check_field("redirection", $settings)) {
            $redirection = new Redirection();
            $redirection->add_actions();
        }

        if ($this->check_field("open_graph", $settings)) {
            $og = new Open_Graph();
            $og->add_actions();
        }

        if ($this->check_field("twitter", $settings)) {
            $tc = new Twitter_Cards();
            $tc->add_actions();
        }

        if ($this->check_field("analytics", $settings)) {
            $analytics = new Analytics();
            $analytics->add_actions();
        }

        if ($this->check_field("webmaster", $settings)) {
            $webmaster = new Webmaster();
            $webmaster->add_actions();
        }

        if ($this->check_field("sitemaps", $settings)) {
            $sitemap = new Sitemap();         
        }

        if ($this->check_field("optimization", $settings)) {
            $optimization = new Optimization();  
            $optimization->add_actions();       
        }
    }

    public function check_field($field_name, $settings)
    {
        if (isset($settings["general"][$field_name]) && $settings["general"][$field_name]) {
            return true;
        } else {
            return false;
        }
    }
}
