<?php

namespace LadderSEO;

/**
 * The file that defines the analytics plugin logics
 *
 *
 * @link       https://digitaldreamstech.com
 * @since      1.0.0
 *
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/src
 */


class Analytics extends Core
{
    public function __construct()
    {
        parent::__construct();
    }

    public function add_actions()
    {
        add_action('wp_footer', [ $this, 'add_analytics_js' ]);
        add_action('wp_enqueue_scripts', [ $this, 'add_analytics_js']);
    }

    public function add_analytics_js()
    {
        $settings = get_option(LADDER_SEO_SETTINGS);
        $google_analytics_code =  !empty($settings["analytics"]["google_app_id"]) ? $this->output_analytics_js("google", $settings["analytics"]["google_app_id"]) : "";
        $bing_analytics_code =  !empty($settings["analytics"]["bing_app_id"]) ? $this->output_analytics_js("bing", $settings["analytics"]["bing_app_id"]) : "";
        $yandex_analytics_code =  !empty($settings["analytics"]["yandex_app_id"]) ? $this->output_analytics_js("yandex", $settings["analytics"]["yandex_app_id"]) : "";
        $mixpanel_analytics_code =  !empty($settings["analytics"]["mixpanel_app_id"]) ? $this->output_analytics_js("mixpanel", $settings["analytics"]["mixpanel_app_id"]) : "";
        $baidu_analytics_code =  !empty($settings["analytics"]["baidu_app_id"]) ? $this->output_analytics_js("baidu", $settings["analytics"]["baidu_app_id"]) : "";

        $analytics_code = $google_analytics_code.$bing_analytics_code.$yandex_analytics_code.$mixpanel_analytics_code;
        echo $analytics_code;// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

    }

    private function output_analytics_js($type, $app_id)
    {
        switch (strtolower($type)) {
            case "google": return $this->get_google_analytics_js($app_id);
            case "bing": return $this->get_bing_analytics_js($app_id);
            case "yandex": return $this->get_yandex_analytics_js($app_id);
            case "mixpanel": return $this->get_mixpanel_analytics_js($app_id);
            case "baidu": return $this->get_baidu_analytics_js($app_id);
        }
        return "";
    }

    public function get_google_analytics_js( $app_id) {

        wp_register_script(
            'ladder-seo-google-analytics',
            'https://www.googletagmanager.com/gtag/js?id=' . esc_attr($app_id),
            array(),
            null,
            true
        );

        // Enqueue the script
        wp_enqueue_script('ladder-seo-google-analytics');

        // Add inline js to initialize gtag
        $inline_js = "window.dataLayer = window.dataLayer || [];\n";
        $inline_js .= "function gtag(){dataLayer.push(arguments);}\n";
        $inline_js .= "gtag('js', new Date());\n";
        $inline_js .= "gtag('config', '" . esc_js($app_id) . "');\n";

        wp_add_inline_script('ladder-seo-google-analytics', $inline_js);
    }

    private function get_bing_analytics_js($app_id)
    {
         $inline_js = "(function(c,l,a,r,i,t,y){
        c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
        t=l.createElement(r);t.async=1;t.src='https://www.clarity.ms/tag/'+i;
        y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
        })(window, document, 'clarity', 'script', '" . esc_js($app_id) . "');";

        wp_add_inline_script('ladder-seo', $inline_js);
    }

    private function get_yandex_analytics_js($app_id)
    {
        // Register the main yandex script
        wp_register_script(
            'ladder-seo-yandex',
            'https://mc.yandex.ru/metrika/tag.js',
            array(),
            null,
            true
        );
        wp_enqueue_script('ladder-seo-yandex');

        // Inline initialization script
        $inline_js = "(function(m,e,t,r,i,k,a){
            m[i]=m[i]||function(){(m[i].a=m[i].a||[]).push(arguments)};
            m[i].l=1*new Date();
            k=e.createElement(t),a=e.getElementsByTagName(t)[0],
            k.async=1;k.src=r;a.parentNode.insertBefore(k,a)
        })(window, document, 'script', 'https://mc.yandex.ru/metrika/tag.js', 'ym');
        ym(" . esc_js($app_id) . ", 'init', {
            clickmap:true,
            trackLinks:true,
            accurateTrackBounce:true
        });";

        wp_add_inline_script('ladder-seo-yandex', $inline_js);

        // Add noscript pixel using wp_footer hook or output buffer if needed
        add_action('wp_footer', function() use ($app_id) {
            echo '<noscript><div><img src="https://mc.yandex.ru/watch/' . esc_attr($app_id) . '" style="position:absolute; left:-9999px;" alt="" /></div></noscript>';// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
        });
    }

    private function get_mixpanel_analytics_js($app_id){
        // Register mixpanel lib script (async loads inside)
            wp_register_script(
                'ladder-seo-mixpanel',
                '//cdn.mxpnl.com/libs/mixpanel-2-latest.min.js',
                array(),
                null,
                true
            );
            wp_enqueue_script('ladder-seo-mixpanel');

            // Inline initialization
            $inline_js = "(function(e,a){
                if(!a.__SV){
                    var b=window;
                    try{var c,l,i,j=b.location,g=j.hash;
                        c=function(a,b){return(l=a.match(RegExp(b+'=([^&]*)')))?l[1]:null};
                        g&&c(g,'state')&&(i=JSON.parse(decodeURIComponent(c(g,'state'))),
                        'mpeditor'===i.action&&(b.sessionStorage.setItem('_mpcehash',g),
                        history.replaceState(i.desiredHash||'',e.title,j.pathname+j.search)))}
                    catch(m){}
                    var k,h;
                    window.mixpanel=a;a._i=[];
                    a.init=function(b,c,f){
                        function e(b,a){
                            var c=a.split('.');
                            2==c.length&&(b=b[c[0]],a=c[1]);
                            b[a]=function(){b.push([a].concat(Array.prototype.slice.call(arguments,0)))};
                        }
                        var d=a;
                        'undefined'!==typeof f?d=a[f]=[]:f='mixpanel';
                        d.people=d.people||[];
                        d.toString=function(b){
                            var a='mixpanel';
                            'mixpanel'!==f&&(a+='.'+f);
                            b||(a+=' (stub)');
                            return a;
                        };
                        d.people.toString=function(){return d.toString(1)+'.people (stub)';};
                        k='disable time_event track track_pageview track_links track_forms register register_once alias unregister identify name_tag set_config reset people.set people.set_once people.unset people.increment people.append people.union people.track_charge people.clear_charges people.delete_user'.split(' ');
                        for(h=0;h<k.length;h++)e(d,k[h]);
                        a._i.push([b,c,f])
                    };
                    a.__SV=1.2;
                    b=e.createElement('script');
                    b.type='text/javascript';
                    b.async=!0;
                    b.src='undefined'!==typeof MIXPANEL_CUSTOM_LIB_URL?MIXPANEL_CUSTOM_LIB_URL:'//cdn.mxpnl.com/libs/mixpanel-2-latest.min.js';
                    c=e.getElementsByTagName('script')[0];
                    c.parentNode.insertBefore(b,c)
                }
            })(document,window.mixpanel||[]);
            mixpanel.init('" . esc_js($app_id) . "');";

            wp_add_inline_script('ladder-seo-mixpanel', $inline_js);
    }

    private function get_baidu_analytics_js($app_id)
    {
        $inline_js = "var _hmt = _hmt || [];
        (function() {
            var hm = document.createElement('script');
            hm.src = 'https://hm.baidu.com/hm.js?" . esc_js($app_id) . "';
            var s = document.getElementsByTagName('script')[0];
            s.parentNode.insertBefore(hm, s);
        })();";

        wp_add_inline_script('ladder-seo', $inline_js);
    }

}
