document.addEventListener('DOMContentLoaded', () => {
	
	document.querySelectorAll('script[type="text/javascript"], style[type="text/css"]').forEach(el => {
		el.removeAttribute('type');
	});

    document.querySelectorAll('[id]').forEach((el) => {
        const id = el.id;
        const duplicates = document.querySelectorAll(`[id="${id}"]`);
        if (duplicates.length > 1) {
            duplicates.forEach((dup, index) => {
                if (index > 0) {
                    dup.id = `${id}-${index}`;
                }
            });
        }
    });
});
