<?php
/**
 *
 * @link              https://digitaldreamstech.com
 * @since             1.0.0
 * @package           Ladder_SEO
 *
 * @wordpress-plugin
 * Plugin Name:       Ladder SEO
 * Plugin URI:        https://ladder-seo.com
 * Description:       Ladder SEO is an all-in-one automated SEO solution for WordPress, powered by AI. It's built for users who want powerful results without the hassle. With a hands-free approach, it effortlessly optimizes your site by handling all the essential SEO settings for you.
 * Version:           1.0.0
 * Author:            Pritesh Gupta
 * Author URI:        https://digitaldreamstech.com/
 * Requires at least: 5.6
 * Requires PHP:      7.2
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       ladder-seo
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}
if (!defined('LADDER_SEO_PATH')) {
    define('LADDER_SEO_PATH', dirname(__FILE__));
}

if (!defined('LADDER_SEO_FILE')) {
    define('LADDER_SEO_FILE', __FILE__);
}

if (!defined('LADDER_SEO_PLUGIN_DIR')) {
    define('LADDER_SEO_PLUGIN_DIR', untrailingslashit(plugin_dir_path(__FILE__)));
}

if (!defined('LADDER_SEO_PLUGIN_URL')) {
    define('LADDER_SEO_PLUGIN_URL', untrailingslashit(plugins_url('', __FILE__)));
}

if (!defined('LADDER_SEO_PLUGIN_BASENAME')) {
    define('LADDER_SEO_PLUGIN_BASENAME', untrailingslashit(plugin_basename(__FILE__)));
}

if (!defined('LADDER_SEO_PLUGIN_BASENAME_PATH')) {
    define('LADDER_SEO_PLUGIN_BASENAME_PATH', plugin_basename(__FILE__));
}

if (!defined('LADDER_SEO_ADMIN_DIR')) {
    define('LADDER_SEO_ADMIN_DIR', LADDER_SEO_PLUGIN_DIR . "/admin");
}

if (!defined('LADDER_SEO_FRONTEND_DIR')) {
    define('LADDER_SEO_FRONTEND_DIR', LADDER_SEO_PLUGIN_DIR . "/public");
}

if (!defined('LADDER_SEO_SETTINGS')) {
    define( 'LADDER_SEO_SETTINGS', 'ladder_seo_settings' );
}

/**
 * Currently plugin version.
 */
define( 'LADDER_SEO_VERSION', '1.0.0' );

function ladder_seo_activate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-ladder-seo-activator.php';
	Ladder_SEO_Activator::activate();
}

function ladder_seo_deactivate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-ladder-seo-deactivator.php';
	Ladder_SEO_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'ladder_seo_activate' );
register_deactivation_hook( __FILE__, 'ladder_seo_deactivate' );

require plugin_dir_path( __FILE__ ) . 'includes/class-ladder-seo.php';

/**
 *
 * @since    1.0.0
 */
function ladder_seo_run() {

	$plugin = new Ladder_SEO();
	$plugin->run();

}
ladder_seo_run();
$base = new \LadderSEO\Base();
$base->run();