<?php

/**
 * Fired during plugin activation
 *
 * @link       https://digitaldreamstech.com
 * @since      1.0.0
 *
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/includes
 * @author     Pritesh Gupta <g.pritesh@gmail.com>
 */
class Ladder_SEO_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {
		$settings = self::get_default_settings();
        update_option(LADDER_SEO_SETTINGS, $settings);

		$db_manager = new \LadderSEO\DB_Manager();
		$db_manager->install_dbs();
	}

	public static function get_default_settings(){
		$settings["general"]["meta_tags"] = 1;//enable(1) or disable(0) auto generation of meta tags.
		$settings["general"]["meta_description"] = 1;//enable(1) or disable(0) auto generation of meta desc.
		$settings["general"]["meta_robots"] = 1;//enable(1) or disable(0) auto generation of meta robot tags.
		$settings["general"]["open_graph"] = 1;//enable(1) or disable(0) auto generation of open graph tags.
		$settings["general"]["twitter"] = 1;//enable(1) or disable(0) auto generation of twitter tags.
		$settings["general"]["canonical_url"] = 1;//enable(1) or disable(0) auto generation of canonical URL.
		$settings["general"]["rel"] = 1;//enable(1) or disable(0) auto generation of "rel" links.
		$settings["general"]["sitemaps"] = 1;//enable(1) or disable(0) auto generation of XML sitemap.
		$settings["general"]["image_alt"] = 1;//enable(1) or disable(0) auto generation of image alt text.
		$settings["general"]["image_title"] = 1;//enable(1) or disable(0) auto generation of image alt text.
		$settings["general"]["breadcrumbs"] = 1;//enable(1) or disable(0) auto generation of breadcrumbs.
		$settings["general"]["redirection"] = 1;//enable(1) or disable(0) auto redirection.
		$settings["general"]["optimization"] = 1;//enable(1) or disable(0) optimization
		$settings["general"]["webmaster"] = 1;//enable(1) or disable(0) webmaster
		$settings["general"]["analytics"] = 1;//enable(1) or disable(0) analytics
		$settings["general"]["schema"] = 1;//enable(1) or disable(0) schema
		$settings["general"]["bulk_AI"] = 1;//enable(1) or disable(0) bulk content generation using AI
		
		$settings["ai"]["llm"] = ""; //LLM
		$settings["ai"]["model"] = ""; //Model
		$settings["ai"]["key"] = ""; //key
		$settings["ai"]["maxtokens"] = 512; //maxtokens
		$settings["ai"]["temperature"] = 0.7; //temperature

		$settings["content_types"]["title_and_description"]["show_in_search_results"] = 1; //enable(1) or disable(0) show in search result
		$settings["content_types"]["title_and_description"]["meta_title"] = "{{site_title}}{{separator}}{{tagline}}"; //default meta title
		$settings["content_types"]["title_and_description"]["meta_description"] = "{{post_description}}"; //default meta description
		$settings["content_types"]["social"]["facebook_image"] = ""; //default facebook image
		$settings["content_types"]["social"]["twitter_image"] = ""; //default twitter image
		$settings["content_types"]["schema_type"]["default_schema"] = ""; //default schema

		$settings["w3c"]["image_alt"] = 1;//enable(1) or disable(0) auto generation alt tags for images.
		$settings["w3c"]["type_attributes"] = 1;//enable(1) or disable(0) remove type attribute warnings	
		$settings["w3c"]["aria_var"] = 1;//enable(1) or disable(0) auto generation of aria elements
		$settings["w3c"]["duplicate_id"] = 0;//enable(1) or disable(0) auto correction of duplicate ids
		$settings["w3c"]["doctype"] = 1;//enable(1) or disable(0) auto generation of doctype declaration

		$settings["optimization"]["shortlinks"] = 0; //enable(1) or disable(0) auto removal of shortlinks
		$settings["optimization"]["rest_api"] = 0; //enable(1) or disable(0) auto removal of resp api links
		$settings["optimization"]["external_system"] = 0; //enable(1) or disable(0) auto removal of external systems
		$settings["optimization"]["generator_tag"] = 0; //enable(1) or disable(0) auto removal of generator tag
		$settings["optimization"]["ping_httpheader"] = 0; //enable(1) or disable(0) auto removal of ping http header
		$settings["optimization"]["powered_httpheader"] = 0; //enable(1) or disable(0) auto removal of powered http header

		$settings["global"]["home"]["title"] = "{{site_title}}{{separator}}{{tagline}}"; //website title
		$settings["global"]["home"]["description"] = "{{tagline}}"; //home page meta description
		$settings["global"]["site"]["image"] = ""; //default website image
		$settings["global"]["site"]["facebook_image"] = ""; //default facebook image
		$settings["global"]["site"]["twitter_image"] = ""; //default twitter image		
		$settings["global"]["site"]["title_seperator"] = "-"; //default title seprator
		$settings["global"]["knowledge_graph"]["website_name"] = "{{site_title}}"; //website name
		$settings["global"]["knowledge_graph"]["alternate_title"] = ""; //website alternate title
		$settings["global"]["knowledge_graph"]["person_or_organization"] = "organization"; //person or Organization
		$settings["global"]["knowledge_graph"]["chose_a_person"] = ""; //person id
		$settings["global"]["knowledge_graph"]["organization_name"] = "{{site_title}}"; // Organization name
		$settings["global"]["knowledge_graph"]["alternate_organization_name"] = ""; // Organization name
		$settings["global"]["knowledge_graph"]["organization_description"] = "{{tagline}}"; // Organization description
		$settings["global"]["knowledge_graph"]["organization_address"] = ""; // Organization address
		$settings["global"]["knowledge_graph"]["contact_person"] = ""; // Organization contact person
		$settings["global"]["knowledge_graph"]["opening_hours"] = ""; // Organization opening hours
		$settings["global"]["knowledge_graph"]["closing_hours"] = ""; // Organization closing hours
		$settings["global"]["knowledge_graph"]["email"] = ""; // email
		$settings["global"]["knowledge_graph"]["phone_number"] = ""; // phone number
		$settings["global"]["knowledge_graph"]["founding_date"] = ""; // founding date
		$settings["global"]["knowledge_graph"]["no_of_employees"] = ""; // no of employees
		$settings["global"]["knowledge_graph"]["organization_logo"] = ""; // logo

		$settings["social"]["facebook_page_url"] = "";//social profile - facebook page url
		$settings["social"]["twitter_page_url"] = "";//social profile - twitter page url
		$settings["social"]["instagram_url"] = "";//social profile - instagram url
		$settings["social"]["youtube_url"] = "";//social profile - youtube  url
		$settings["social"]["pinterest_url"] = "";//social profile - Pinterest   url
		$settings["social"]["linkedIn_url"] = "";//social profile - LinkedIn  url
		$settings["social"]["tumblr_url"] = "";//social profile - Tumblr   url
		$settings["social"]["tiktok_url"] = "";//social profile - tiktok  url
		$settings["social"]["yelp_url"] = "";//social profile - yelp  url
		$settings["social"]["soundcloud_url"] = "";//social profile - SoundCloud  url
		$settings["social"]["wordpress_url"] = "";//social profile - WordPress  url
		$settings["social"]["myspace_url"] = "";//social profile - MySpace  url
		$settings["social"]["wikipedia_url"] = "";//social profile - Wikipedia  url
		$settings["social"]["additional_page_url"] = "";//social profile - additional page  url

		$settings["webmaster"]["google"] = ""; //analytics code for google
		$settings["webmaster"]["bing"] = ""; //analytics code for bing
		$settings["webmaster"]["yandex"] = ""; //analytics code  for yandex
		$settings["webmaster"]["baidu"] = ""; //analytics code  for baidu
		$settings["webmaster"]["pinterest"] = ""; //analytics code  for Pinterest

		$settings["analytics"]["google_app_id"] = ""; //analytics code for google
		$settings["analytics"]["bing_app_id"] = ""; //analytics code for bing
		$settings["analytics"]["yandex_app_id"] = ""; //analytics code  for yandex
		$settings["analytics"]["mixpanel_app_id"] = ""; //analytics code  for Mixpanel
		$settings["analytics"]["baidu_app_id"] = ""; //analytics code  for baidu

		$settings["content"]["generate_content"] = 0; //whether to generate bulk content or not
		$settings["content"]["topic"] = ""; //topic to be used for content generation
		$settings["content"]["keywords"] = ""; //list of keywords in comma seperated format
		$settings["content"]["categories"] = ""; //list of categories
		$settings["content"]["post_type"] = "post"; //post, page etc.
		$settings["content"]["post_status"] = "publish"; //publish, draft, pending etc.
		$settings["content"]["total_articles"] = 0; //total articles to be generated
		$settings["content"]["duration"] = "now"; //duration, now, each_day, each_week, each_month...default 'now'

		return $settings;
	}

}