<?php

// Prevent direct call
defined('ABSPATH') || exit;

/**
 * Helper class
 *
 * @link       https://ladder-seo.com
 * @since      1.0.0
 *
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/helper
 */
/**
 * Helper class to generate HTML Form Elements
 *
 * @since      1.0.0
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/helper
 * @author     Pritesh Gupta <g.pritesh@gmail.com>
 */
class Ladder_SEO_Helper_Elements extends Ladder_SEO_Helper
{
    /**
     * Initialize the helper class
     *
     * @since    1.0.0
     */
    public function __construct()
    {

    }

    public function ladderseoGetButtonField($fieldName, $attr, $data = array(), $fieldClass = array())
    {
        $class = implode(" ", $fieldClass);
        $field = "<button type=\"button\" class=\"btn  $class\" id=\"$fieldName\" name=\"$fieldName\" ";
        $buttonText = "";

        if (is_array($attr) && count($attr)) {
            foreach ($attr as $c => $v) {
                $field .= " $c=\"$v\" ";
            }
        }

        if (is_array($data) && count($data)) {
            $buttonText = $data[0];
        }
        $field .= " >$buttonText</button>";
        return $field;
    }

    public function ladderseoGetCheckboxField($fieldName, $attr, $data, $fieldData, $fieldClass = array())
    {
        $class = implode(" ", $fieldClass);
        $field = "<div class=\"checkbox  ladderseo-checkbox-group\">";
        if (is_array($fieldData) && count($fieldData)) {
            $loopFields = 0;
            foreach ($fieldData as $fieldsval) {
                $field .= "<div class=\"form-check form-check-inline\">";
                $field .= "<input type=\"checkbox\" class=\"form-check-input ladderseo-form-control ladderseo-checkbox $class\" id=\"$fieldName.$loopFields\" name=\"$fieldName\" ";

                if (is_array($attr) && count($attr)) {
                    foreach ($attr as $c => $v) {
                        $field .= " $c=\"$v\" ";
                    }
                }

                $fieldsval = array_values($fieldsval);
                $field .= "value=\"$fieldsval[0]\" ";
                $selected = "";
                if (isset($data[0]) && !empty($data[0])) {
                    $values = explode(",", $data[0]);
                    if (is_array($values) && count($values)) {
                        if (in_array($fieldsval[0], $values)) {
                            $field .= "checked=\"checked\"";
                        }
                    }
                }

                $field .= " />";
                $field .= "<label class=\"checkbox-inline form-check-label\">";
                $field .= $fieldsval[1];
                $field .= "</label>";
                $field .= "</div>";
                $loopFields++;
            }
        }
        $field .= "</div>";
        return $field;
    }

    public function ladderseoGetDivider($divider = "hr", $attr = array(), $data = array(), $fieldClass = array(), $fieldName = "")
    {
        $class = implode(" ", $fieldClass);
        if (is_array($attr) && count($attr)) {
            $dividerattr = "";
            foreach ($attr as $c => $v) {
                $dividerattr .= " $c=\"$v\" ";
            }
        }
        if (isset($data[0])) {
            return "<$divider id=\"$fieldName\" name=\"$fieldName\" class=\"$class\" $dividerattr>".$data[0]."</$divider>";
        } else {
            return "<$divider id=\"$fieldName\" name=\"$fieldName\" class=\"$class\" $dividerattr></$divider>";
        }

    }

    public function ladderseoGetHeading($heading = "h1", $attr = array(), $data = array(), $fieldClass = array(), $fieldName = "")
    {
        $class = implode(" ", $fieldClass);
        if (is_array($attr) && count($attr)) {
            $headingattr = "";
            foreach ($attr as $c => $v) {
                $headingattr .= " $c=\"$v\" ";
            }
        }
        if (isset($data[0])) {
            return "<$heading class=\"$class\" id=\"$fieldName\" name=\"$fieldName\" $headingattr>".$data[0]."</$heading>";
        } else {
            return "<$heading class=\"$class\" id=\"$fieldName\" name=\"$fieldName\" $headingattr></$heading>";
        }

    }

    public function ladderseoGetHTMLContent($html, $fieldClass = array(), $fieldName = "")
    {
        if (is_array($html)) {
            $html = $html[0];
        }
        if (is_array($fieldClass) && count($fieldClass)) {
            $class = implode(" ", $fieldClass);
            $html_content = "<div id=\"$fieldName\" name=\"$fieldName\" class=\"$class\">$html</div>";
            return $html_content;
        }

        return $html;
    }

    public function ladderseoGetImage($attr = array(), $data = array(), $fieldClass = array(), $fieldName = "")
    {
        $class = implode(" ", $fieldClass);
        $imageattr = "";
        if (is_array($attr) && count($attr)) {
            foreach ($attr as $c => $v) {
                $imageattr .= " $c=\"$v\" ";
            }
        }
        if (isset($data[0])) {
            return "<img id=\"$fieldName\" name=\"$fieldName\" class=\"$class\" $imageattr src=\"$data[0]\"/>";
        } else {
            return "<img id=\"$fieldName\" name=\"$fieldName\" class=\"$class\" $imageattr />";
        }

    }

    public function ladderseoGetInputField($fieldName, $attr = array(), $data = array(), $type = "text", $fieldClass = array(), $fieldId = "")
    {
        $class = implode(" ", $fieldClass);
        $id = empty($fieldId) ? $fieldName : $fieldId;
        $field = "<input type=\"$type\" class=\"form-control $class\" id=\"$id\" name=\"$fieldName\" ";

        if (is_array($attr) && count($attr)) {
            foreach ($attr as $c => $v) {
                $field .= " $c=\"$v\" ";
            }
        }

        if (is_array($data) && count($data)) {
            $field .= " value=\"$data[0]\" ";
        }
        $field .= " />";
        return $field;
    }

    public function ladderseoGetLabelField($labelText, $labelFor, $labelClass = array())
    {
        $class = implode(" ", $labelClass);
        $class .= " control-label col-form-label";
        $label = "<label for=\"$labelFor\" class=\"$class\">$labelText</label>";
        return $label;
    }


    public function ladderseoGetListElements($data, $attr = array(), $position = "1", $listElementTag = "ul")
    {
        $listElement = "";

        if (is_array($attr) && count($attr)) {
            $listattr = "";
            foreach ($attr as $c => $v) {
                $listattr .= " $c=\"$v\" ";
            }
        }

        if ($position === 0) {
            $listElement .= "<" . $listElementTag . " $listattr>";
        } elseif ($position === -1) {
            $listElement .= "</$listElementTag>";
        } else {
            if (is_array($data)) {
                foreach ($data as $row) {
                    $listElement .= "<li $listattr>$row</li>";
                }
            }
        }

        return $listElement;
    }

    public function ladderseoGetParagraph($paragraph = "p", $attr = array(), $data = array(), $fieldClass = array(), $fieldName = "")
    {
        $class = implode(" ", $fieldClass);
        if (is_array($attr) && count($attr)) {
            $paragraphattr = "";
            foreach ($attr as $c => $v) {
                $paragraphattr .= " $c=\"$v\" ";
            }
        }
        if (isset($data[0])) {
            return "<$paragraph id=\"$fieldName\" name=\"$fieldName\" class=\"$class\" $paragraphattr>".$data[0]."</$paragraph>";
        } else {
            return "<$paragraph id=\"$fieldName\" name=\"$fieldName\" class=\"$class\" $paragraphattr></$paragraph>";
        }

    }

    public function ladderseoGetRadioButtonField($fieldName, $attr, $data, $fieldData, $fieldClass = array(), $divClass = "")
    {
        $class = implode(" ", $fieldClass);
        $field = "<div class=\"radio  ladderseo-radio-group $divClass\">";
        if (is_array($fieldData) && count($fieldData)) {
            $loopFields = 0;
            foreach ($fieldData as $fieldsval) {

                $field .= "<div class=\"form-check form-check-inline\">";
                $field .= "<input type=\"radio\" class=\"form-check-input ladderseo-form-control ladderseo-radio $class\" id=\"$fieldName.$loopFields\" name=\"$fieldName\" ";

                if (is_array($attr) && count($attr)) {
                    foreach ($attr as $c => $v) {
                        $field .= " $c=\"$v\" ";
                    }
                }

                $fieldsval = array_values($fieldsval);
                $field .= "value=\"$fieldsval[0]\" ";
                $selected = "";
                if (in_array($fieldsval[0], $data)) {
                    $field .= "checked=\"checked\"";
                }

                $field .= " />";
                $field .= "<label class=\"form-check-label radio-inline\">";
                $field .= $fieldsval[1];
                $field .= "</label>";
                $field .= "</div>";
                $loopFields++;
            }
        }
        $field .= "</div>";
        return $field;
    }

    public function ladderseoGetRadioButtonFieldasButton($fieldName, $attr, $data, $fieldData, $fieldClass = array(), $divClass = "")
    {
        $class = implode(" ", $fieldClass);
        $field = "<div class=\"btn-group ladderseo-radio-btn-group $divClass\" role=\"group\">";
        if (is_array($fieldData) && count($fieldData)) {
            $loopFields = 0;
            foreach ($fieldData as $fieldsval) {

                $field .= "<input  autocomplete=\"off\" type=\"radio\" class=\"btn-check ladderseo-form-control ladderseo-radio $class\" id=\"$fieldName.$loopFields\" name=\"$fieldName\" ";

                if (is_array($attr) && count($attr)) {
                    foreach ($attr as $c => $v) {
                        $field .= " $c=\"$v\" ";
                    }
                }

                $fieldsval = array_values($fieldsval);
                $field .= "value=\"$fieldsval[0]\" ";
                $selected = "";
                if (in_array($fieldsval[0], $data)) {
                    $field .= "checked=\"checked\"";
                }

                $field .= " />";
                $field .= "<label for=\"$fieldName.$loopFields\" class=\"btn btn-primary\">";
                $field .= $fieldsval[1];
                $field .= "</label>";
                $loopFields++;
            }
        }
        $field .= "</div>";
        return $field;
    }


    public function ladderseoGetListRadioGroupField($fieldName, $attr, $data, $fieldData, $fieldClass = array(), $divClass = "")
    {
        $class = implode(" ", $fieldClass);
        $field = "<div class=\"list-group $divClass\">";
        if (is_array($fieldData) && count($fieldData)) {
            $loopFields = 0;
            foreach ($fieldData as $fieldsval) {


                $field .= "<label class=\"list-group-item d-flex gap-2\">";
                $field .= "<input class=\"form-check-input flex-shrink-0 $class\" type=\"radio\" id=\"$fieldName.$loopFields\" name=\"$fieldName\" ";

                if (is_array($attr) && count($attr)) {
                    foreach ($attr as $c => $v) {
                        $field .= " $c=\"$v\" ";
                    }
                }

                $fieldsval = array_values($fieldsval);
                $field .= "value=\"$fieldsval[0]\" ";
                if (in_array($fieldsval[0], $data)) {
                    $field .= "checked=\"checked\"";
                }

                $field .= " />";
                $field .= "<span>";
                $field .= $fieldsval[1];
                $field .= "<small class=\"d-block text-body-secondary\">";
                $field .= $fieldsval[2];
                $field .= "</small>";
                $field .= "</span>";
                $field .= "</label>";
                $loopFields++;
            }
        }
        $field .= "</div>";
        return $field;
    }

    public function ladderseoGetSelectField($fieldName, $attr, $data, $fieldData, $fieldClass = array())
    {
        $class = implode(" ", $fieldClass);
        $field = "<select class=\"form-control ladderseo-form-control ladderseo-select wp-db-fb-co-select $class\" id=\"$fieldName\" name=\"$fieldName\"";
        $multi = false;
        if (is_array($attr) && count($attr)) {
            foreach ($attr as $c => $v) {
                $field .= " $c=\"$v\" ";
                if ($c === "multiple") {
                    $multi = true;
                }
            }
        }
        $field .= ">";

        if ($multi && isset($data[0])) {
            $data = explode(",", $data[0]);
        }

        if (is_array($fieldData) && count($fieldData)) {
            foreach ($fieldData as $fieldsval) {
                $fieldsval = array_values($fieldsval);
                $selected = "";

                if (in_array($fieldsval[0], $data)) {
                    $selected = "selected=\"selected\"";
                }

                $field .= "<option $selected value=\"$fieldsval[0]\">$fieldsval[1]</option>";
            }
        }
        $field .= "</select>";
        return $field;
    }

    public function ladderseoGetTable($table_id = "", $attr = array(), $data = array(), $fieldClass = array())
    {
        $class = implode(" ", $fieldClass);
        if (is_array($attr) && count($attr)) {
            $tableattr = "";
            foreach ($attr as $c => $v) {
                $tableattr .= " $c=\"$v\" ";
            }
        }

        $table_output = '<table id="'.$table_id.'" name="'.$table_id.'" class="' . $class . '" >';
        $table_head = "<thead>";
        $table_body = '<tbody>';
        $loop_count = 0;

        if (is_array($data) && count($data)) {
            foreach ($data as $k => $v) {
                if ($loop_count == 0) {
                    $table_head .= '<tr id="row_' . $loop_count . '">';
                } else {
                    $table_body .= '<tr id="row_' . $loop_count . '">';
                }

                foreach ($v as $col => $row) {
                    if ($loop_count == 0) {
                        $table_head .= '<th>' . $row . '</th>';
                    } else {
                        $table_body .= '<td>' . $row . '</td>';
                    }
                }
                $table_body .= '</tr>';
                if ($loop_count == 0) {
                    $table_body .= '</tr></thead>';
                }

                $loop_count++;
            }
        }

        $table_body .= '</tbody>';
        return $table_output . $table_head . $table_body . '</table>';

    }

    public function ladderseoGetTextareaField($fieldName, $attr, $data, $fieldClass = array())
    {
        $class = implode(" ", $fieldClass);
        $field = "<textarea class=\"form-control ladderseo-form-control  ladderseo-textarea $class\" id=\"$fieldName\" name=\"$fieldName\" ";

        if (is_array($attr) && count($attr)) {
            foreach ($attr as $c => $v) {
                $field .= " $c=\"$v\" ";
            }
        }
        $field .= ">";
        if (is_array($data) && count($data)) {
            $field .= $data[0];
        }
        $field .= "</textarea>";
        return $field;
    }

    public function ladderseoGetDiv($divId, $divText, $divClass = array())
    {
        $class = implode(" ", $divClass);
        $div = "<div id=\"$divId\" class=\"$class\">$divText</div>";
        return $div;
    }

    public function ladderseoGetSwitch($fieldName, $attr, $data, $fieldData, $fieldClass = array())
    {
        $class = implode(" ", $fieldClass);
        $field = "<div class=\"form-check form-switch\">";

        $field .= "<input type=\"checkbox\" role=\"switch\" class=\"form-check-input ladderseo-form-control ladderseo-checkbox $class\" id=\"$fieldName\" name=\"$fieldName\" ";
        if (is_array($attr) && count($attr)) {
            foreach ($attr as $c => $v) {
                $field .= " $c=\"$v\" ";
            }
        }

        $selected = "";
        if(is_array($data) && count($data) && $data[0] ==="enabled")
            $field .= "checked=\"checked\"";

        $field .= " />";
        $field .= "<label class=\"form-check-label\" for=\"$fieldName\">";
        $field .= isset($fieldData[0]) ? $fieldData[0] : "";
        $field .= "</label>";

        $field .= "</div>";       
        return $field;
    }

    public function ladderseoGetToggle($fieldName, $attr, $data, $fieldData, $fieldClass = array()){
        $status = esc_html__("Disabled","ladder-seo");
        $class = implode(" ", $fieldClass);
        $field = "<div class=\"ladderseo__toggle_container\">";        
        $field .= "<div class=\"ladderseo__toggle\">";
        $field .= "<input type=\"checkbox\" id=\"$fieldName\" name=\"$fieldName\" class=\"ladderseo__toggle__input\" ";
        if (is_array($attr) && count($attr)) {
            foreach ($attr as $c => $v) {
                $field .= " $c=\"$v\" ";
            }
        }

        $selected = "";        
        if($data){
            $field .= "checked=\"checked\"";
            $status = esc_html__("Enabled","ladder-seo");
        }
            

        $field .= " />";
        $field .= "<label for=\"$fieldName\" class=\"ladderseo__toggle__label\"></label>";
        $field .= " </div>";
        $field .= "<span class=\"ladderseo__toggle_span\">$status</span>";
        $field .= " </div>";     
        return $field;
    }

    public function ladderseoGetEditor($fieldName, $attr, $data, $fieldData, $fieldClass = array()){
        $class = implode(" ", $fieldClass);
        $field = "<div class=\"editor-section\">";
        $field .= "<div id=\"quick-buttons-$fieldName\" class=\"quick-buttons-container\" ";
        if (is_array($attr) && count($attr)) {
            foreach ($attr as $c => $v) {
                $field .= " $c=\"$v\" ";
            }
        }
        $field .= "></div>";
        $field .= "<div id=\"$fieldName\" class=\"editor-container $class\">";
        if(isset($data[0])){
            $field .= $data[0];    
        }
        $field .= "</div></div>";
        return $field;
    }
    public function ladderseoGetField($fieldType, $fieldName, $attr, $data, $fieldData = array(), $fieldClass = array()){
        switch($fieldType){
            case "input" : return $this->ladderseoGetInputField($fieldName, $attr, $data, "text", $fieldClass);
            case "date" : return $this->ladderseoGetInputField($fieldName, $attr, $data, "date", $fieldClass);
            case "select" : $fieldClass = array("ladderseo-select2");
                            return $this->ladderseoGetSelectField($fieldName, $attr, $data, $fieldData, $fieldClass );
            case "checkbox" : return $this->ladderseoGetCheckboxField($fieldName, $attr, $data, $fieldData, $fieldClass );
            case "textarea" : return $this->ladderseoGetTextareaField($fieldName, $attr, $data, $fieldClass);
            case "radio" : return $this->ladderseoGetRadioButtonFieldasButton($fieldName, $attr, $data, $fieldData, $fieldClass);
            case "toggle" : return $this->ladderseoGetToggle($fieldName, $attr, $data, $fieldData, $fieldClass);
            case "editor" : return $this->ladderseoGetEditor($fieldName, $attr, $data, "text", $fieldClass);
            case "image" :                 
                $output = $this->ladderseoGetInputField($fieldName, $attr, $data, "hidden", $fieldClass);
                $fieldClass = array("ladderseo-upload-media-image","ladderseo-replace-image");
                $data = !empty($data[0]) ? $data : array(LADDER_SEO_PLUGIN_URL."/admin/images/placeholder.jpeg"); 
                $output .= $this->ladderseoGetImage(array(), $data, $fieldClass, $fieldName);
                $divId = wp_rand()."ladderseo-media-image-container";
                $divClass = array("ladderseo-media-image-container");
                $output = $this->ladderseoGetDiv($divId, $output, $divClass);
                $fieldClass = array('ladderseo-open-media', "btn", "btn-primary", "ladderseo-btn-media","ladderseo-buttons");
                $data = array(esc_html__("Select", "ladder-seo"));
                $uploadFieldName = $fieldName."_upload_button";
                $output .= $this->ladderseoGetButtonField($uploadFieldName, $attr, $data, $fieldClass);
                $fieldClass = array('ladderseo-delete-media', "btn", "btn-primary", "ladderseo-btn-media","ladderseo-buttons");
                $deleteFieldName = $fieldName."_delete_button";
                $data = array(esc_html__("Remove", "ladder-seo"));
                $output .= $this->ladderseoGetButtonField($deleteFieldName, $attr, $data, $fieldClass);
                return $output;
            default : return $this->ladderseoGetInputField($fieldName, $attr, $data, "text", $fieldClass);
        }

    }


}
