<?php

// Prevent direct call
defined('ABSPATH') || exit;

/**
 * Helper class
 *
 * @link       https://ladder-seo.com
 * @since      1.0.0
 *
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/helper
 */
/**
 * Helper class for ladder-seo
 *
 * This class defines all common code that helps main class.
 *
 * @since      1.0.0
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/helper
 * @author     Pritesh Gupta <g.pritesh@gmail.com>
 */
class Ladder_SEO_Helper
{
    /**
     * Initialize the helper class
     *
     * @since    1.0.0
     */
    public function __construct()
    {
    }

    /**
    * Get all post types
    *
    * @since    1.0.0
    */
    public function get_post_types()
    {
        $post_types = get_post_types([ 'public' => true ]);
        unset($post_types['attachment']);
        return apply_filters('ladderseo_post_types', $post_types);
    }

    /**
    * Get all taxonomies
    *
    * @since    1.0.0
    */
    public function get_taxonomies()
    {
        $taxonomies = get_taxonomies([
            'public'  => true,
            'show_ui' => true,
        ]);
        return apply_filters('ladderseo_taxonomies', $taxonomies);
    }

    /**
    * Get all posts
    *
    * @since    1.0.0
    */
    public function get_all_posts(){
      $args = array('orderby'          => 'date',
                    'numberposts'      => -1,
		                'order'            => 'DESC');
      $posts = get_posts($args);
      return $posts;
    }

    /**
    * Get all terms
    *
    * @since    1.0.0
    */
    public function get_all_terms(){
      $args = array (
        'orderby' => 'name',
        'order' => 'ASC',);
      $terms = get_terms($args);
      return $terms;
    }
  
    /**
    * check local or live enviornment
    *
    * @since    1.0.0
    */
    public function is_local_environment() {
      // Get the current hostname
      $hostname = isset($_SERVER['HTTP_HOST']) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_HOST'] ) ) : '';
  
      // Define what is considered "local" (you can add more cases if needed)
      $local_patterns = ['localhost', '127.0.0.1', '::1'];
  
      // Check if the hostname matches any local patterns
      if (in_array($hostname, $local_patterns)) {
          return true; // It's a local environment
      }
  
      return false; // It's a live server
  }

}
