<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<form id="ladderseo_analytics_form_settings" class="needs-validation ladderseo-forms" method="post" enctype="multipart/form-data">
    <?php wp_nonce_field('ladder_seo', 'ladder_seo_nonce'); ?>
    <div class="row">
        <div class="col-xl-12">
            <div class="card ladderseo-cards overflow-hidden border">
                <div class="card-header justify-content-between border-bottom-0">
                    <h5 class="mb-3"><?php esc_html_e("Webmaster Tools", "ladder-seo")?></h5>
                    <a href="javascript:void(0);" data-bs-toggle="collapse" data-bs-target="#ladderseo_webmaster_settings"
                        aria-expanded="true" aria-controls="#ladderseo_webmaster_settings">
                        <i class="ri-arrow-down-s-line fs-18 collapse-open">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" class="feather feather-chevron-down">
                                <polyline points="6 9 12 15 18 9"></polyline>
                            </svg>
                        </i>
                        <i class="ri-arrow-up-s-line collapse-close fs-18">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" class="feather feather-chevron-up">
                                <polyline points="18 15 12 9 6 15"></polyline>
                            </svg>
                        </i>
                    </a>
                </div>
                <div class="card-body" id="ladderseo_webmaster_settings">
                    <?php $webmaster_fields = isset($settings["webmaster"])? $settings["webmaster"]: array();?>
                    <?php foreach($webmaster_fields as $webmaster_field_name => $webmaster_field_val) { 
                        $field_name = "ladderseo_webmaster_".$webmaster_field_name;
                        $field_title = Ladder_SEO_Util::get_field_title($webmaster_field_name);
                        $help_text = Ladder_SEO_Util::get_field_help_text($webmaster_field_name);
                        ?>
                    <div class="col-12 ladderseo-webmaster-settings">
                        <div class="row ladderseo-control-wrapper">
                            <div class="col-3 ladderseo-control-label">
                                <?php
                                $labelFor = $field_name;
                                $labelText = esc_html($field_title);
                                $labelClass = array("form-label");
                                echo wp_kses($helper->ladderseoGetLabelField($labelText, $labelFor, $labelClass), $allowed_html);
                                ?>
                            </div>
                            <div class="col-9 ladderseo-control-field">
                                <?php    
                        $fieldName = $field_name;
                        $attr = array( );
                        $data = isset($settings["webmaster"][$webmaster_field_name])? array($settings["webmaster"][$webmaster_field_name]) : array();
                        $fieldClass = array();
                        echo wp_kses($helper->ladderseoGetInputField($fieldName, $attr,  $data, "text", $fieldClass), $allowed_html) ;             
                        ?>

                            </div>
                            <div class="ladderseo-control-help">
                                <?php    
                                $divId = $field_name."_help";
                                $class = array("form-text");
                                $text = esc_html($help_text);
                                echo wp_kses($helper->ladderseoGetDiv($divId, $text, $class), $allowed_html);
                                ?>
                            </div>
                        </div>
                    </div>

                    <?php }//end of foreach ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xl-12">
            <div class="card ladderseo-cards overflow-hidden border">
                <div class="card-header justify-content-between border-bottom-0">
                    <h5 class="mb-3"><?php esc_html_e("Analytics Code", "ladder-seo")?></h5>
                    <a href="javascript:void(0);" data-bs-toggle="collapse" data-bs-target="#ladderseo_analytics_settings"
                        aria-expanded="true" aria-controls="#ladderseo_analytics_settings">
                        <i class="ri-arrow-down-s-line fs-18 collapse-open">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" class="feather feather-chevron-down">
                                <polyline points="6 9 12 15 18 9"></polyline>
                            </svg>
                        </i>
                        <i class="ri-arrow-up-s-line collapse-close fs-18">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" class="feather feather-chevron-up">
                                <polyline points="18 15 12 9 6 15"></polyline>
                            </svg>
                        </i>
                    </a>
                </div>
                <div class="card-body" id="ladderseo_analytics_settings">

                    <?php $analytics_fields = isset($settings["analytics"])? $settings["analytics"]: array();?>
                    <?php foreach($analytics_fields as $analytics_field_name => $analytics_field_val) { 
                    $field_name = "ladderseo_analytics_".$analytics_field_name;
                    $field_title = Ladder_SEO_Util::get_field_title($analytics_field_name);
                    $help_text = Ladder_SEO_Util::get_field_help_text($analytics_field_name);
                    ?>
                    <div class="col-12 ladderseo-anlytics-settings">
                        <div class="row ladderseo-control-wrapper">
                            <div class="col-3 ladderseo-control-label">
                                <?php
                                    $labelFor = $field_name;
                                    $labelText = esc_html($field_title);
                                    $labelClass = array("form-label");
                                    echo wp_kses($helper->ladderseoGetLabelField($labelText, $labelFor, $labelClass), $allowed_html);
                            ?>
                            </div>
                            <div class="col-9 ladderseo-control-field">
                                <?php    
                                $fieldName = $field_name;
                                $attr = array( );
                                $data = isset($settings["analytics"][$analytics_field_name])? array($settings["analytics"][$analytics_field_name]) : array();
                                $fieldClass = array();
                                echo wp_kses($helper->ladderseoGetInputField($fieldName, $attr,  $data, "text", $fieldClass), $allowed_html) ;             
                                ?>

                            </div>
                            <div class="ladderseo-control-help">
                                <?php    
                                $divId = $field_name."_help";
                                $class = array("form-text");
                                $text = esc_html($help_text);
                                echo wp_kses($helper->ladderseoGetDiv($divId, $text, $class), $allowed_html);
                                ?>
                            </div>
                        </div>
                    </div>

                    <?php }//end of foreach ?>
                </div>
            </div>
        </div>
    </div>


    <div class="col-12 d-flex justify-content-end mt-3">
        <input type="submit"
            class="ladderseo-submit-button ladderseo-buttons ladderseo-save-settings btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light  me-3"
            id="ladderseo_save_analytics_settings" value="<?php esc_html_e('Save', 'ladder-seo') ?>" />
        <button type="reset" class="btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light">
            <?php esc_html_e('Reset', 'ladder-seo') ?>
        </button>
    </div>

</form>