<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<form id="ladderseo_social_form_settings" class="needs-validation ladderseo-forms" method="post" enctype="multipart/form-data">
    <?php wp_nonce_field('ladder_seo', 'ladder_seo_nonce'); ?>
    <?php $social_fields = isset($settings["social"])? $settings["social"]: array();?>
    <?php foreach($social_fields as $social_field_name => $social_field_val) { 
        $field_name = "ladderseo_social_".$social_field_name;
        $field_title = Ladder_SEO_Util::get_field_title($social_field_name);
        ?>
    <div class="col-12 ladderseo-social-settings">
        <div class = "row ladderseo-control-wrapper">
            <div class ="col-3 ladderseo-control-label">
        <?php
                $labelFor = $field_name;
                $labelText = esc_html ($field_title);
                $labelClass = array("form-label");
                echo wp_kses($helper->ladderseoGetLabelField($labelText, $labelFor, $labelClass), $allowed_html);
        ?>
            </div>
            <div class ="col-9 ladderseo-control-field">
        <?php    
                $fieldName = $field_name;
                $attr = array( );
                $data = isset($settings["social"][$social_field_name])? array($settings["social"][$social_field_name]) : array();
                $fieldClass = array();
                echo wp_kses($helper->ladderseoGetInputField($fieldName, $attr,  $data, "text", $fieldClass), $allowed_html) ;             
                ?>
                
            </div>
        </div>  
    </div>
    <?php }//end of foreach ?>
    <div class="col-12 d-flex justify-content-end mt-3">
        <input type="submit"
        class="ladderseo-submit-button ladderseo-buttons ladderseo-save-settings btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light  me-3"
        id="ladderseo_save_social_settings" value="<?php esc_html_e('Save', 'ladder-seo') ?>" />
        <button type="reset" class="btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light">
            <?php esc_html_e('Reset', 'ladder-seo') ?>
        </button>
    </div>
   
</form>