<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<!-- Modal -->
<div class="modal fade" id="ladderseo_redirection" tabindex="-1" aria-labelledby="ladderseo_redirection_Label" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="ladderseo_redirection_Label">
                    <?php esc_html_e("Add redirections", "ladder-seo") ?>
                </h1>
                <button type="button" class="btn-close ladderseo-buttons " data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="card ladderseo-cards">
                    <div class="card-body">

                        <form id="ladderseo_redirection_form_settings" class="needs-validation ladderseo-forms" method="post"
                            enctype="multipart/form-data">
                            <?php wp_nonce_field('ladder_seo', 'ladder_seo_nonce'); ?>

                            <div class="col-12 ladderseo-seo-redirection-settings">
                                <?php
                                    $labelFor = "ladderseo_redirection_source_url";
                                    $labelText =  esc_html__("Source url", "ladder-seo");
                                    $labelClass = array("form-label");
                                    echo wp_kses($helper->ladderseoGetLabelField($labelText, $labelFor, $labelClass), $allowed_html);

                                    $fieldName = "ladderseo_redirection_source_url";
                                    $attr = array( );
                                    $fieldClass = array();
                                    $data = array();
                                    echo wp_kses($helper->ladderseoGetInputField($fieldName, $attr,  $data, "text", $fieldClass), $allowed_html) ;             
                        
                                    $divId = "ladderseo_redirection_source_url_help";
                                    $class = array("form-text");
                                    $text = esc_html__("Source url", "ladder-seo");
                                    echo wp_kses($helper->ladderseoGetDiv($divId, $text, $class), $allowed_html);
                                ?>
                            </div> 
                            
                            <div class="col-12 ladderseo-seo-redirection-settings">
                                <?php
                                    $labelFor = "ladderseo_redirection_target_url";
                                    $labelText =  esc_html__("Target url", "ladder-seo");
                                    $labelClass = array("form-label");
                                    echo wp_kses($helper->ladderseoGetLabelField($labelText, $labelFor, $labelClass), $allowed_html);

                                    $fieldName = "ladderseo_redirection_target_url";
                                    $attr = array( );
                                    $fieldClass = array();
                                    $data = array();
                                    echo wp_kses($helper->ladderseoGetInputField($fieldName, $attr,  $data, "text", $fieldClass), $allowed_html) ;             
                        
                                    $divId = "ladderseo_redirection_target_url_help";
                                    $class = array("form-text");
                                    $text = esc_html__("Target url", "ladder-seo");
                                    echo wp_kses($helper->ladderseoGetDiv($divId, $text, $class), $allowed_html);
                                ?>
                            </div> 
                            <div class="col-12 ladderseo-seo-redirection-settings">
                                <?php
                                        $labelFor = "ladderseo_redirection_type";
                                        $labelText =  esc_html__("Redirection type", "ladder-seo");
                                        $labelClass = array("form-label");
                                        echo wp_kses($helper->ladderseoGetLabelField($labelText, $labelFor, $labelClass), $allowed_html);

                                        $fieldName = "ladderseo_redirection_type";
                                        $attr = array();
                                        $data = array();
                                        $placeholder =  esc_html__('Select', 'ladder-seo');
                                        $option0 = array("301",esc_html__('301 Moved Permanently', 'ladder-seo'));
                                        $option1 = array("302",esc_html__('302 Found', 'ladder-seo'));
                                        $option2 = array("307",esc_html__('307 Temporary Redirect', 'ladder-seo'));
                                        $option3 = array("410",esc_html__('410 Gone', 'ladder-seo'));          
                                        
                                        $fieldData = array($option0, $option1, $option2, $option3);
                                        echo wp_kses($helper->ladderseoGetSelectField($fieldName, $attr, $data, $fieldData), $allowed_html);        

                                        $divId = "ladderseo_redirection_type_help";
                                        $class = array("form-text");
                                        $text = esc_html__("Select redirection type", "ladder-seo");
                                        echo wp_kses($helper->ladderseoGetDiv($divId, $text, $class), $allowed_html);
                                        ?>
                            </div>
                        
                            <div class="col-12 d-flex justify-content-end mt-3">
                                <input type="submit"
                                    class="ladderseo-submit-button ladderseo-buttons ladderseo-save-settings btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light  me-3"
                                    id="ladderseo_save_redirection_settings"
                                    value="<?php esc_html_e('Save', 'ladder-seo') ?>" />
                                <button type="reset"
                                    class="btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light">
                                    <?php esc_html_e('Reset', 'ladder-seo') ?>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary ladderseo-buttons " data-bs-dismiss="modal">
                    <?php esc_html_e("Close", "ladder-seo") ?></button>
                <button type="button" class="btn btn-primary ladderseo-buttons " id="ladderseo_bulk_action_apply">
                    <?php esc_html_e("Apply changes", "ladder-seo") ?></button>
            </div>
        </div>
    </div>
</div>


<div class="ladderseo-redirection-header">
    <!-- Button trigger modal -->
    <button type="button" class="btn btn-primary ladderseo-buttons " data-bs-toggle="modal" data-bs-target="#ladderseo_redirection">
        <?php esc_html_e("Add redirection", "ladder-seo") ?>
    </button>
</div>
<?php require LADDER_SEO_PLUGIN_DIR . '/admin/partials/redirection/ladder-seo-admin-redirection-data.php'; ?>