<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<form id="ladderseo_optimization_form_settings" class="needs-validation ladderseo-forms" method="post" enctype="multipart/form-data">
    <?php wp_nonce_field('ladder_seo', 'ladder_seo_nonce'); ?>
    <?php $optimization_fields = isset($settings["optimization"])? $settings["optimization"]: array();?>
    <?php foreach($optimization_fields as $optimization_field_name => $optimization_field_val) { 
        $field_name = "ladderseo_optimization_".$optimization_field_name;
        $field_title = esc_html__("Remove ", "ladder-seo").Ladder_SEO_Util::get_field_title($optimization_field_name);
        $help_text = Ladder_SEO_Util::get_field_help_text($optimization_field_name);
        ?>
    <div class="col-12 ladderseo-optimization-settings">
        <div class = "row ladderseo-control-wrapper">
            <div class ="col-3 ladderseo-control-label">
        <?php
                $labelFor = $field_name;
                $labelText = esc_html($field_title);
                $labelClass = array("form-label");
                echo wp_kses($helper->ladderseoGetLabelField($labelText, $labelFor, $labelClass), $allowed_html);
        ?>
            </div>
            <div class ="col-9 ladderseo-control-field">
            <?php    
                $fieldName = $field_name;
                $attr = array();
                $fieldData = array(esc_html($field_title));
                $data = $optimization_field_val;
                echo wp_kses($helper->ladderseoGetToggle($fieldName, $attr, $data, $fieldData, $fieldClass = array()), $allowed_html);        
                ?>
                <div class ="ladderseo-control-help">
                <?php    
                $divId = $field_name."_help";
                $class = array("form-text");
                $text = esc_html($help_text) ;
                echo wp_kses($helper->ladderseoGetDiv($divId, $text, $class), $allowed_html);
                ?>
                </div>
            </div>
        </div>  
    </div>
    <?php }//end of foreach ?>
    <div class="col-12 d-flex justify-content-end mt-3">
        <input type="submit"
        class="ladderseo-submit-button ladderseo-buttons ladderseo-save-settings btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light  me-3"
        id="ladderseo_save_optimization_settings" value="<?php esc_html_e('Save', 'ladder-seo') ?>" />
        <button type="reset" class="btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light">
            <?php esc_html_e('Reset', 'ladder-seo') ?>
        </button>
    </div>
    
</form>