<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<?php
    wp_nonce_field('ladder_seo', 'ladder_seo_nonce');
     ?>
     
    <div id="ladderseo-meta-box-container" class="ladderseo-meta-box">
        <ul class="ladderseo-meta-box-tabs">
            <li><a href="#ladderseo-general"><?php esc_html_e("General","ladder-seo");?></a></li>
            <li><a href="#ladderseo-social"><?php esc_html_e("Social","ladder-seo");?></a></li>
            <li><a href="#ladderseo-schema"><?php esc_html_e("Schema","ladder-seo");?></a></li>
            <li><a href="#ladderseo-ai"><?php esc_html_e("Writing assistant (AI)","ladder-seo");?></a></li>
            <li><a href="#ladderseo-resources"><?php esc_html_e("Resources","ladder-seo");?></a></li>
        </ul>
        <div class="ladderseo-tab-content" id="ladderseo-general">
            <!-- Meta title -->
            <div class="ladderseo-form-group">
                <label for="ladderseo_<?php echo esc_html($type)?>-meta_title"><?php esc_html_e("Meta title","ladder-seo");?></label>
                <input type="text" id="ladderseo_<?php echo esc_html($type)?>-meta_title" 
                name="ladderseo_<?php echo esc_html($type)?>-meta_title"
                value="<?php echo esc_html($data[$type]["meta_title"]); ?>">
                <button class="ladderseo-buttons ladderseo-btn-insert-tag" type="button"><?php esc_html_e("Insert tag","ladder-seo");?></button>
                <button class="ladderseo-btn-generate-content-ai ladderseo-buttons" id="ladderseo_generate_meta_title" type="button"><?php esc_html_e("Generate meta title using AI","ladder-seo");?></button>
                <p class="description"><?php esc_html_e("Here you can write SEO meta title. You can also use AI to generate SEO meta title based on the content of article. Recommended length: ≤ 60 characters.","ladder-seo");?></p>
            </div>

            <!-- Meta description -->
            <div class="ladderseo-form-group">
                <label for="ladderseo_<?php echo esc_html($type)?>-meta_description"><?php esc_html_e("Meta Description","ladder-seo");?></label>
                <input type="text" id="ladderseo_<?php echo esc_html($type)?>-meta_description" 
                name="ladderseo_<?php echo esc_html($type)?>-meta_description"
                value="<?php echo esc_html($data[$type]["meta_description"]); ?>">
                <button class="ladderseo-btn-insert-tag ladderseo-buttons" type="button"><?php esc_html_e("Insert tag","ladder-seo");?></button>

                <button class="ladderseo-btn-generate-content-ai ladderseo-buttons" id="ladderseo_generate_meta_description" type="button"><?php esc_html_e("Generate meta description using AI","ladder-seo");?></button>
                <p class="description"><?php esc_html_e("Here you can write SEO meta description. You can also use AI to generate SEO meta description based on the content of article. Recommended length: 50-160 characters.","ladder-seo");?></p>
            </div>

            <!-- Canonical Url -->
            <div class="ladderseo-form-group">
                <label for="ladderseo_<?php echo esc_html($type)?>-canonical"><?php esc_html_e("Canonical URL","ladder-seo");?></label>
                <input type="text" id="ladderseo_<?php echo esc_html($type)?>-canonical" 
                name="ladderseo_<?php echo esc_html($type)?>-canonical"
                value="<?php echo esc_html($data[$type]["canonical"]); ?>">
                <p class="description"><?php esc_html_e("if you have multiple posts or pages with similar content, it tells the search engines what URL contains the original content","ladder-seo");?></p>
            </div>


            <!-- Hide from search result -->
            <div class="ladderseo-form-group">
                <label for="ladderseo_hide_from_result">
                    <input type="checkbox" id="ladderseo_hide_from_result" name="ladderseo_hide_from_result" value="1" <?php checked(get_post_meta($post->ID, 'ladderseo_hide_from_result', true), '1'); ?>> 
                    <?php echo esc_html_e("Hide from search result", "ladder-seo");?>
                </label>
                <p class="description"><?php esc_html_e("You can hide this post/page from search result by checking this box.","ladder-seo");?></p>
            </div>

        </div>

        <div class="ladderseo-tab-content" id="ladderseo-social">
             <!-- Facebook image -->
             <div class="ladderseo-form-group">
                <label for="ladderseo_<?php echo esc_html($type)?>-facebook_image"><?php esc_html_e("Facebook Image","ladder-seo");?></label>
                <div class="col-9">
                    <input type="hidden" class="form-control " id="ladderseo_<?php echo esc_html($type)?>-facebook_image" name="ladderseo_<?php echo esc_html($type)?>-facebook_image" value="">
                    <img id="" class="ladderseo-upload-media-image ladderseo-replace-image" 
                     src="<?php echo esc_url($data[$type]['facebook_image']) ?>" >
                    <button type="button" class="btn ladderseo-buttons ladderseo-open-media btn btn-primary ladderseo-btn-media" id="_upload_button" name="_upload_button" data-tags="site_title,post_title,separator"><?php esc_html_e("Select","ladder-seo");?></button>
                    <button type="button" class="btn  ladderseo-buttons ladderseo-delete-media btn btn-primary ladderseo-btn-media" id="_delete_button" name="_delete_button" data-tags="site_title,post_title,separator"><?php esc_html_e("Remove","ladder-seo");?></button>                
                </div>
                
            </div>

             <!-- twitter image -->
             <div class="ladderseo-form-group">
                <label for="ladderseo_<?php echo esc_html($type)?>-twitter_image"><?php esc_html_e("twitter Image","ladder-seo");?></label>
                <div class="col-9">
                    <input type="hidden" class="form-control " id="ladderseo_<?php echo esc_html($type)?>-twitter_image" name="ladderseo_<?php echo esc_html($type)?>-twitter_image" value="">
                    <img id="" class="ladderseo-upload-media-image ladderseo-replace-image" 
                    src="<?php echo esc_url($data[$type]['twitter_image']) ?>" >
                    <button type="button" class="btn ladderseo-buttons ladderseo-open-media btn btn-primary ladderseo-btn-media" id="_upload_button" name="_upload_button" data-tags="site_title,post_title,separator"><?php esc_html_e("Select","ladder-seo");?></button>
                    <button type="button" class="btn ladderseo-buttons ladderseo-delete-media btn btn-primary ladderseo-btn-media" id="_delete_button" name="_delete_button" data-tags="site_title,post_title,separator"><?php esc_html_e("Remove","ladder-seo");?></button>                
                </div>
                
            </div>
        </div>
        <div class="ladderseo-tab-content" id="ladderseo-schema">
            <div class="ladderseo-form-group">
                <label for="ladderseo_<?php echo esc_html($type)?>-schema"><?php esc_html_e("Use schema","ladder-seo");?></label>
                <select id="ladderseo_<?php echo esc_html($type)?>-schema" name="ladderseo_<?php echo esc_html($type)?>-schema">
                   <?php
                   foreach($schemas as $key => $schema){?>
                    <option value="<?php echo esc_html($key)?>" 
                    <?php if(isset($post)) 
                        {
                            selected(get_post_meta($post->ID, "ladderseo_".esc_html($type)."-schema", true), $key); 
                        } else if(isset($term)) 
                        {
                            selected(get_post_meta($term->ID, "ladderseo_".esc_html($type)."-schema", true), $key); 
                        }
                        ?>>
                        <?php echo esc_html($schema) ?>
                    </option>
                    <?php 
                    }?>
                </select>
                <p class="description"><?php esc_html_e("Set schema for the page.","ladder-seo");?></p>
            </div>
        </div>
        <div class="ladderseo-tab-content " id="ladderseo-ai">
            <div class="ladderseo-pro-feature-avail">
            <!-- keywords -->
            <div class="ladderseo-form-group">
                <label for="ladderseo_keywords"><?php esc_html_e("Keywords","ladder-seo");?></label>
                <input type="text" id="ladderseo_keywords" 
                name="ladderseo_keywords"
                value="<?php echo isset($data[$type]["ladderseo_keywords"]) ? esc_html($data[$type]["ladderseo_keywords"]) : ""; ?>">
                <p class="description"><?php esc_html_e("Write focus keyword (in comma seperated format), you want this page or post to rank for. AI will use this keywords to generate content.","ladder-seo");?></p>
            </div>

             <!-- Type -->
             <div class="ladderseo-form-group">
                <label for="ladderseo_generate_title_content"><input type="radio" id="ladderseo_generate_title_content" name="ladderseo_content_generation_type" value="title_and_content" <?php checked(get_post_meta($post->ID, 'ladderseo_content_generation_type', true), 'title_and_content'); ?>> 
                    <?php echo esc_html_e("Generate title and content", "ladder-seo")?>
                </label>
                <label for="ladderseo_generate_content_spin"><input type="radio" id="ladderseo_generate_content_spin" name="ladderseo_content_generation_type" value="regenerate" <?php checked(get_post_meta($post->ID, 'ladderseo_content_generation_type', true), 'spin'); ?>>
                    <?php echo esc_html_e("Repurpose(spin)", "ladder-seo")?>
                </label>
                <p class="description"><?php esc_html_e("You can use AI to generate SEO optimized content. You can either generate title and content by providing some brief information, using AI or transform existing post to SEO optimized post.","ladder-seo");?></p>
            </div>

            <!-- brief information -->
            <div class="ladderseo-form-group" id="ladderseo_div_generate_title_content">
                <label for="ladderseo_brief_description"><?php esc_html_e("Write brief description of topic you want to write about","ladder-seo") ?></label>
                <textarea id="ladderseo_brief_description" name="ladderseo_brief_description"><?php echo esc_textarea(get_post_meta($post->ID, 'ladderseo_brief_description', true)); ?></textarea>
                <button class="ladderseo-btn-generate-content-ai ladderseo-buttons" id="ladderseo_ai_action_generate_title_content" type="button"><?php esc_html_e("Generate title and content using AI","ladder-seo");?></button>
                <p class="description"><?php esc_html_e("Here, you need write some information about the article you want to generate. Generated article will be shown below.","ladder-seo");?></p>
            </div>

             <!-- regenerate (spin) -->
             <div class="ladderseo-form-group">
                <button class="ladderseo-btn-generate-content-ai ladderseo-buttons" id="ladderseo_ai_action_spin" type="button"><?php esc_html_e("Regenerate(spin) ","ladder-seo");?></button>
                <p class="description"><?php esc_html_e("You can use this button to rewrite the existing post using AI. Generated content will be shown below","ladder-seo");?></p>
            </div>

            <!-- Generated title -->
            <div class="ladderseo-form-group">
                <label for="ladderseo_generated_title"><?php esc_html_e("Title","ladder-seo");?></label>
                <input type="text" id="ladderseo_generated_title" 
                name="ladderseo_generated_title" />
                <p class="description"><?php esc_html_e("This box shows the generated post title using AI.","ladder-seo");?></p>
            </div>

            <!-- Generated content -->
            <div class="ladderseo-form-group">
                <label for="ladderseo_generated_description"><?php esc_html_e("Content","ladder-seo") ?></label>
                <textarea id="ladderseo_generated_description" name="ladderseo_generated_description"></textarea>
                <p class="description"><?php esc_html_e("This box shows the generated post description using AI.","ladder-seo");?></p>
            </div>

            <div class="ladderseo-form-group">
            <button class="ladderseo-btn-generate-content-ai ladderseo-buttons" id="ladderseo_ai_action_regenerate" type="button"><?php esc_html_e("Regenerate","ladder-seo");?></button>
            <button class="ladderseo-btn-generate-content-ai ladderseo-buttons" id="ladderseo_use_content" type="button"><?php esc_html_e("Use this content to populate title and content","ladder-seo");?></button>
            <p class="description"><?php esc_html_e("You can either copy AI generated content to post title and post content or you can click on 'Regenerate' button to spin the article to create more versions.","ladder-seo");?></p>
            </div>
            </div>
            <?php require LADDER_SEO_PLUGIN_DIR . '/admin/partials/ladder-seo-admin-pro-message.php'; ?>
                
        </div>
        <div class="ladderseo-tab-content" id="ladderseo-resources">
            <div class="ladderseo-pro-feature-avail">
            <div class="ladderseo-form-group">
                <label for="ladderseo_resources"><?php esc_html_e("Enter keywords to search resources","ladder-seo");?></label>
                <input type="text" id="ladderseo_resources" 
                name="ladderseo_resources"
                value="<?php echo esc_html($data[$type]["resources"]); ?>">
                <button id="ladderseo_get_resources" class="ladderseo-buttons ladderseo-btn-find-resources" type="button"><?php esc_html_e("Find resources","ladder-seo");?></button>
                <p class="description"><?php esc_html_e("Set resource for the page.","ladder-seo");?></p>
            </div>
            <div id="ladderseo-gallery">
            </div>
            </div>
            <?php require LADDER_SEO_PLUGIN_DIR . '/admin/partials/ladder-seo-admin-pro-message.php'; ?>
        </div>
    </div>
    <div id="ladderseo-tags-dropdown" class="ladderseo-tag-dropdown">
        <ul id="ladderseo-tags-list"></ul>
    </div>
<?php
?>