<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<?php
    wp_nonce_field('ladder_seo', 'ladder_seo_nonce');
     ?>
    <div id="ladderseo-meta-box-container" class="ladderseo-meta-box">
        <ul class="ladderseo-meta-box-tabs">
            <li><a href="#ladderseo-general"><?php esc_html_e("General","ladder-seo");?></a></li>
            <li><a href="#ladderseo-social"><?php esc_html_e("Social","ladder-seo");?></a></li>
            <li><a href="#ladderseo-schema"><?php esc_html_e("Schema","ladder-seo");?></a></li>
        </ul>
        <div class="ladderseo-tab-content" id="ladderseo-general">
             <!-- Meta title -->
             <div class="ladderseo-form-group">
                <label for="ladderseo_<?php echo esc_html($type)?>-meta_title"><?php esc_html_e("Meta title","ladder-seo");?></label>
                <input type="text" id="ladderseo_<?php echo esc_html($type)?>-meta_title" 
                name="ladderseo_<?php echo esc_html($type)?>-meta_title"
                value="<?php echo esc_html($data[$type]["meta_title"]); ?>">
                <button class="ladderseo-btn-generate-content-ai ladderseo-buttons" id="ladderseo_generate_meta_title" type="button"><?php esc_html_e("Generate meta title using AI","ladder-seo");?></button>
                <p class="description"><?php esc_html_e("Here you can write SEO meta title. You can also use AI to generate SEO meta title based on the content of category description. Recommended length: ≤ 60 characters.","ladder-seo");?></p>
            </div>

            <!-- Meta description -->
            <div class="ladderseo-form-group">
                <label for="ladderseo_<?php echo esc_html($type)?>-meta_description"><?php esc_html_e("Meta Description","ladder-seo");?></label>
                <input type="text" id="ladderseo_<?php echo esc_html($type)?>-meta_description" 
                name="ladderseo_<?php echo esc_html($type)?>-meta_description"
                value="<?php echo esc_html($data[$type]["meta_description"]); ?>">
                <button class="ladderseo-btn-generate-content-ai ladderseo-buttons" id="ladderseo_generate_meta_description" type="button"><?php esc_html_e("Generate meta description using AI","ladder-seo");?></button>
                <p class="description"><?php esc_html_e("Here you can write SEO meta description. You can also use AI to generate SEO meta description based on the content of category description. Recommended length: ≤ 60 characters.","ladder-seo");?></p>
            </div>

             <!-- Canonical Url -->
             <div class="ladderseo-form-group">
                <label for="ladderseo_<?php echo esc_html($type)?>-canonical"><?php esc_html_e("Canonical URL","ladder-seo");?></label>
                <input type="text" id="ladderseo_<?php echo esc_html($type)?>-canonical" 
                name="ladderseo_<?php echo esc_html($type)?>-canonical"
                value="<?php echo esc_html($data[$type]["canonical"]); ?>">
                <p class="description"><?php esc_html_e("if you have multiple categories with similar content, it tells the search engines what URL contains the original content","ladder-seo");?></p>
            </div>

            <!-- Hide from search result -->
            <div class="ladderseo-form-group">
                <label for="ladderseo_hide_from_result">
                    <input type="checkbox" id="ladderseo_hide_from_result" name="ladderseo_hide_from_result" value="1" <?php checked(get_post_meta($post->ID, 'ladderseo_hide_from_result', true), '1'); ?>> 
                    <?php echo esc_html_e("Hide from search result", "ladder-seo");?>
                </label>
                <p class="description"><?php esc_html_e("You can hide this category from search result by checking this box.","ladder-seo");?></p>
            </div>

        </div>

        <div class="ladderseo-tab-content" id="ladderseo-social">
             <!-- Facebook image -->
             <div class="ladderseo-form-group">
                <label for="ladderseo_<?php echo esc_html($type)?>-facebook_image"><?php esc_html_e("Facebook Image","ladder-seo");?></label>
                <div class="col-9">
                    <input type="hidden" class="form-control " id="ladderseo_<?php echo esc_html($type)?>-facebook_image" name="ladderseo_<?php echo esc_html($type)?>-facebook_image" value="">
                    <img id="" class="ladderseo-upload-media-image ladderseo-replace-image" 
                     src="<?php echo esc_url($data[$type]['facebook_image']) ?>" >
                    <button type="button" class="btn ladderseo-open-media btn btn-primary ladderseo-btn-media" id="_upload_button" name="_upload_button" data-tags="site_title,post_title,separator"><?php esc_html_e("Select","ladder-seo");?></button>
                    <button type="button" class="btn ladderseo-delete-media btn btn-primary ladderseo-btn-media" id="_delete_button" name="_delete_button" data-tags="site_title,post_title,separator"><?php esc_html_e("Remove","ladder-seo");?></button>                
                </div>
                
            </div>

             <!-- twitter image -->
             <div class="ladderseo-form-group">
                <label for="ladderseo_<?php echo esc_html($type)?>-twitter_image"><?php esc_html_e("twitter Image","ladder-seo");?></label>
                <div class="col-9">
                    <input type="hidden" class="form-control " id="ladderseo_<?php echo esc_html($type)?>-twitter_image" name="ladderseo_<?php echo esc_html($type)?>-twitter_image" value="">
                    <img id="" class="ladderseo-upload-media-image ladderseo-replace-image"                     
                    src="<?php echo esc_url($data[$type]['twitter_image']) ?>" >
                    <button type="button" class="btn  ladderseo-buttons ladderseo-open-media btn btn-primary ladderseo-btn-media" id="_upload_button" name="_upload_button" data-tags="site_title,post_title,separator"><?php esc_html_e("Select","ladder-seo");?></button>
                    <button type="button" class="btn  ladderseo-buttons ladderseo-delete-media btn btn-primary ladderseo-btn-media" id="_delete_button" name="_delete_button" data-tags="site_title,post_title,separator"><?php esc_html_e("Remove","ladder-seo");?></button>                
                </div>
                
            </div>
        </div>
        <div class="ladderseo-tab-content" id="ladderseo-schema">
            <div class="ladderseo-form-group">
                <label for="ladderseo_<?php echo esc_html($type)?>-schema"><?php esc_html_e("Use schema","ladder-seo");?></label>
                <select id="ladderseo_<?php echo esc_html($type)?>-schema" name="ladderseo_<?php echo esc_html($type)?>-schema">
                   <?php
                   foreach($schemas as $key => $schema){?>
                    <option value="<?php echo esc_html($key)?>" 
                    <?php if(isset($post)) 
                        {
                            selected(get_post_meta($post->ID, "ladderseo_".esc_html($type)."-schema", true), $key); 
                        } else if(isset($term)) 
                        {
                            selected(get_post_meta($term->ID, "ladderseo_".esc_html($type)."-schema", true), $key); 
                        }
                        ?>>
                        <?php echo esc_html($schema) ?>
                    </option>
                    <?php 
                    }?>
                </select>
            </div>
        </div>
    </div>
<?php
?>