<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<div class="row g-3">
    <div class="card ladder-seo-cards overflow-hidden border">
        <div class="card-header justify-content-between border-bottom-0">
            <h5 class="mb-3"><?php esc_html_e("Redirection", "ladder-seo"); ?></h5>
            <a href="javascript:void(0);" data-bs-toggle="collapse" data-bs-target="#ladder-seo_ai_settings"
                aria-expanded="true" aria-controls="ladder-seo_ai_settings">
                <i class="ri-arrow-down-s-line fs-18 collapse-open"><svg xmlns="http://www.w3.org/2000/svg" width="24"
                        height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                        stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down">
                        <polyline points="6 9 12 15 18 9"></polyline>
                    </svg></i>
                <i class="ri-arrow-up-s-line collapse-close fs-18">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                        stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                        class="feather feather-chevron-up">
                        <polyline points="18 15 12 9 6 15"></polyline>
                    </svg>
                </i>
            </a>           
        </div>
        <div id="ladder-seo_redirection_settings" class="card-body">
            <p class="text-muted mb-2"> 
                <?php esc_html_e("Redirections play a crucial role in SEO and website maintenance by ensuring users and search engines are directed to the right pages. When URLs change or pages are removed, proper redirections prevent broken links, maintain SEO rankings, and enhance user experience.","ladder-seo")?>
            </p>
            <ul class="nav nav-tabs mb-3 tab-style-8 scaleX" id="bulkTabs" role="tablist">
                <li class="nav-item" role="presentation"> 
                    <button class="nav-link active" id="ladder-seo-bulk-post-tab"
                        data-bs-toggle="tab" data-bs-target="#ladder-seo-redirection-tab-pane" type="button" role="tab"
                        aria-controls="ladder-seo-redirection-tab-pane" aria-selected="true">
                        <?php esc_html_e("Redirection", "ladder-seo") ?>
                    </button> </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="ladder-seo-404-logs-tab"
                        data-bs-toggle="tab" data-bs-target="#ladder-seo-404-logs-tab-pane" type="button" role="tab"
                        aria-controls="ladder-seo-404-logs-tab-pane" aria-selected="false" tabindex="-1">
                        <?php esc_html_e("404 logs", "ladder-seo") ?>
                    </button> 
                </li>
            </ul>
            <div class="tab-content" id="ladder-seoRedirectionTabContent">
                <div class="tab-pane show active overflow-hidden" id="ladder-seo-redirection-tab-pane" role="tabpanel"
                    aria-labelledby="ladder-seo-redirection-tab" tabindex="0"> 
                    <?php require LADDER_SEO_PLUGIN_DIR . '/admin/partials/redirection/ladder-seo-admin-redirection-form.php'; ?>
                </div>
                <div class="tab-pane overflow-hidden" id="ladder-seo-404-logs-tab-pane" role="tabpanel"
                    aria-labelledby="ladder-seo-404-logs-tab" tabindex="0">
                    <?php require LADDER_SEO_PLUGIN_DIR . '/admin/partials/redirection/ladder-seo-admin-redirection-404-logs-data.php'; ?>
                </div>
            </div>
        </div>
    </div>
</div>