<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<div class="row g-3 ladderseo-pro-message">
    <div class="card ladderseo-cards overflow-hidden border">
        <div class="card-header justify-content-between border-bottom-0 text-center">
            <h3 class="mb-3"><?php
                esc_html_e("Get Ladder SEO Pro and Unlock all the Powerful Features", "ladder-seo"); ?>
            </h3>

        </div>
        <div id="ladderseo_pro" class="card-body">
            <h5 class="text-muted mb-2">
                <?php esc_html_e("Boost your rankings. Drive more traffic. Automate SEO. using pro features of Ladder SEO.", "ladder-seo")?>
            </h5>
            <ul class="ladderseo-pro-features">
                <li>
                    <strong><?php esc_html_e("Advanced Keyword Research Tools:", "ladder-seo"); ?></strong>
                    <?php echo esc_html__(" Easily discover high-performing keywords your audience is searching for. Get suggestions, competition data, and search volume to boost your SEO strategy.", "ladder-seo"); ?>
                </li>

                <li>
                    <strong><?php esc_html_e("W3C Markup Validation & Optimization:", "ladder-seo"); ?></strong>
                    <?php echo esc_html__(" Automatically detect and fix HTML/CSS errors to ensure your site follows the latest web standards—improving both SEO and site accessibility.", "ladder-seo"); ?>
                </li>

                <li>
                    <strong><?php esc_html_e("Bulk Edit SEO Metadata:", "ladder-seo"); ?></strong>
                    <?php echo esc_html__(" Save time by editing SEO titles, descriptions, and meta tags for multiple posts and pages in one go—ideal for large sites and WooCommerce stores.", "ladder-seo"); ?>
                </li>

                <li>
                    <strong><?php esc_html_e("AI-Powered Content Generation with Scheduling:", "ladder-seo"); ?></strong>
                    <?php echo esc_html__(" Instantly create high-quality, SEO-optimized content using AI, and schedule it to be published at the perfect time without lifting a finger.", "ladder-seo"); ?>
                </li>

                <li>
                    <strong><?php esc_html_e("Automated AI Tasks for SEO:", "ladder-seo"); ?></strong>
                    <?php echo esc_html__(" Let AI handle routine SEO tasks like internal linking suggestions, meta description writing, keyword density checks, and more—24/7 assistance for your website.", "ladder-seo"); ?>
                </li>

                <li>
                    <strong><?php esc_html_e("AI Writing Assistant in Post/Page Editor:", "ladder-seo"); ?></strong>
                    <?php echo esc_html__(" Seamlessly integrated AI helper to write or expand your content directly within the WordPress editor. Perfect for blog posts, product descriptions, and service pages.", "ladder-seo"); ?>
                </li>

                <li>
                    <strong><?php esc_html_e("Rewrite or Spin Existing Content with AI:", "ladder-seo"); ?></strong>
                    <?php echo esc_html__(" Instantly transform old or underperforming content into fresh and unique variations using AI-powered rewriting tools.", "ladder-seo"); ?>
                </li>

                <li>
                    <strong><?php esc_html_e("Generate Meta Titles & Descriptions Using AI:", "ladder-seo"); ?></strong>
                    <?php echo esc_html__(" Auto-generate compelling and optimized meta titles and descriptions with one click—ensuring better CTR and SEO compliance.", "ladder-seo"); ?>
                </li>

                <li>
                    <strong><?php esc_html_e("Built-in Resource Library with Free Media (Pixabay API):", "ladder-seo"); ?></strong>
                    <?php echo esc_html__(" Search and insert high-quality royalty-free images and videos directly into your content without leaving WordPress.", "ladder-seo"); ?>
                </li>
            </ul>
            <div class="ladderseo-purchase-btn ladderseo-buttons btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light">
                <a href="<?php echo esc_url("https://ladder-seo.com/pricing/") ?>"> <?php echo esc_html__("Get Ladder SEO Now!", "ladder-seo"); ?></a>
            </div>    
        </div>
    </div>
</div>