<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<div class="row g-3">
    <div class="card ladderseo-cards overflow-hidden border">
        <div class="card-header justify-content-between border-bottom-0">
            <h5 class="mb-3"><?php esc_html_e("Bulk Settings", "ladder-seo"); ?></h5>
            <a href="javascript:void(0);" data-bs-toggle="collapse" data-bs-target="#ladderseo_ai_settings"
                aria-expanded="true" aria-controls="ladderseo_ai_settings">
                <i class="ri-arrow-down-s-line fs-18 collapse-open"><svg xmlns="http://www.w3.org/2000/svg" width="24"
                        height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                        stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down">
                        <polyline points="6 9 12 15 18 9"></polyline>
                    </svg></i>
                <i class="ri-arrow-up-s-line collapse-close fs-18">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                        stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                        class="feather feather-chevron-up">
                        <polyline points="18 15 12 9 6 15"></polyline>
                    </svg>
                </i>
            </a>
        </div>
        <div id="ladderseo_bulk_settings" class="card-body">
            <p class="text-muted mb-2"> 
                <?php esc_html_e("Bulk entry option allows users to efficiently manage SEO settings for multiple posts and taxonomies at once. This feature saves time by enabling quick edits to meta titles, descriptions, and other SEO fields in a single interface.","ladder-seo")?></p>
                <div class="ladderseo-bulk-actions-header">
                    <!-- Button trigger modal -->
                    <button type="button" class="btn btn-primary ladderseo-buttons " data-bs-toggle="modal" data-bs-target="#ladderseo_bulk_popup">
                    <?php esc_html_e("Bulk actions", "ladder-seo") ?>
                    </button>
                </div>
            <ul class="nav nav-tabs mb-3 tab-style-8 scaleX" id="bulkTabs" role="tablist">
                <li class="nav-item" role="presentation"> 
                    <button class="nav-link active" id="ladderseo-bulk-post-tab"
                        data-bs-toggle="tab" data-bs-target="#ladderseo-bulk-post-tab-pane" type="button" role="tab"
                        aria-controls="ladderseo-bulk-post-tab-pane" aria-selected="true">
                        <?php esc_html_e("Posts", "ladder-seo") ?>
                    </button> </li>
                <li class="nav-item" role="presentation"> 
                    <button class="nav-link" id="ladderseo-bulk-taxonomy-tab"
                        data-bs-toggle="tab" data-bs-target="#ladderseo-bulk-taxonomy-tab-pane" type="button" role="tab"
                        aria-controls="ladderseo-bulk-taxonomy-tab-pane" aria-selected="false" tabindex="-1">
                        <?php esc_html_e("Taxonomies", "ladder-seo") ?>
                    </button> </li>
            </ul>
            <div class="tab-content" id="ladderseoBulkTabContent">
                <div class="tab-pane show active overflow-hidden" id="ladderseo-bulk-post-tab-pane" role="tabpanel"
                    aria-labelledby="ladderseo-bulk-post-tab" tabindex="0"> 
                    <?php require LADDER_SEO_PLUGIN_DIR . '/admin/partials/bulk/ladder-seo-admin-bulk-post-form.php'; ?>
                </div>
                <div class="tab-pane overflow-hidden" id="ladderseo-bulk-taxonomy-tab-pane" role="tabpanel"
                    aria-labelledby="ladderseo-bulk-taxonomy-tab" tabindex="0">
                    <?php require LADDER_SEO_PLUGIN_DIR . '/admin/partials/bulk/ladder-seo-admin-bulk-taxonomy-form.php'; ?>
                </div>
            </div>
            <?php require LADDER_SEO_PLUGIN_DIR . '/admin/partials/bulk/ladder-seo-admin-bulk-popup.php'; ?>
        </div>
    </div>
</div>
