<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<form id="ladderseo_keyword_form_settings" class="needs-validation ladderseo-forms" method="post" enctype="multipart/form-data">
<?php wp_nonce_field('ladder_seo', 'ladder_seo_nonce'); ?>

    <div class="col-12 ladderseo-seo-keyword-settings">
        <?php
                $labelFor = "ladderseo_keyword";
                $labelText =  esc_html__("Keyword", "ladder-seo");
                $labelClass = array("form-label");
                echo wp_kses($helper->ladderseoGetLabelField($labelText, $labelFor, $labelClass), $allowed_html);

                //Keyword
                $fieldName = "ladderseo_keyword";
                $attr = array( );
                $fieldClass = array();
                $data = array();
                echo wp_kses($helper->ladderseoGetInputField($fieldName, $attr,  $data, "text", $fieldClass), $allowed_html) ;             
      
                $divId = "ladderseo_keyword_help";
                $class = array("form-text");
                $text = esc_html__("Input keyword to generate list of high traffic seo keywords and long-tail keywords related to the keyword entered.", "ladder-seo");
                echo wp_kses($helper->ladderseoGetDiv($divId, $text, $class), $allowed_html);
                ?>
    </div>
    <div id="ladderseo_keyword_output" class="col-12 ladderseo-seo-keyword-output">

    </div>    
    <div class="col-12 d-flex justify-content-end mt-3">
        <input type="submit"
        class="ladderseo-submit-button ladderseo-buttons ladderseo-save-settings btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light  me-3"
        id="ladderseo_get_high_traffic_keywords" value="<?php esc_html_e('Generate high-traffic SEO keywords', 'ladder-seo') ?>" />
        <button id="ladderseo_get_long_tail_keywords" type="button" class="btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light">
            <?php esc_html_e('Generate long-tail SEO keywords', 'ladder-seo') ?>
        </button>
    </div>   
</form>