<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<form id="ladderseo_global_form_settings" class="needs-validation ladderseo-forms" method="post" enctype="multipart/form-data">
    <?php wp_nonce_field('ladder_seo', 'ladder_seo_nonce'); ?>
    <?php $global_fields = isset($settings["global"]) ? $settings["global"] : array();
    foreach ($global_fields as $key => $global_field) {?>
    <div class="row">
    <div class="col-xl-12">
        <div class="card ladderseo-cards overflow-hidden border">
            <div class="card-header justify-content-between border-bottom-0">
                <h5 class="mb-3 mt-3">
                            <?php 
                                $key_title = Ladder_SEO_Util::get_field_title($key);
                                echo esc_html($key_title); 
                            ?>
                </h5>
                <a href="javascript:void(0);" data-bs-toggle="collapse" data-bs-target="#ladderseo_<?php echo esc_html($key) ?>_settings"
                    aria-expanded="true" aria-controls="#ladderseo_<?php echo esc_html($key) ?>_settings">
                    <i class="ri-arrow-down-s-line fs-18 collapse-open">
                        <svg xmlns="http://www.w3.org/2000/svg"
                            width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                            stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-chevron-down">
                            <polyline points="6 9 12 15 18 9"></polyline>
                        </svg>
                    </i>
                    <i class="ri-arrow-up-s-line collapse-close fs-18">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-chevron-up">
                            <polyline points="18 15 12 9 6 15"></polyline>
                        </svg>
                    </i>
                </a>
            </div>
            <div class="card-body" id="ladderseo_<?php echo esc_html($key) ?>_settings">
        <?php
        foreach ($global_field as $global_field_name => $global_field_val) {
            $field_name = "ladderseo_global_".$key."_".$global_field_name;
            $field_title = Ladder_SEO_Util::get_field_title($global_field_name);
            $field_type = Ladder_SEO_Util::get_field_type($global_field_name);
            $help_text = Ladder_SEO_Util::get_field_help_text($global_field_name);
            ?>
        <div class="col-12 ladderseo-global-settings">
            <div class = "row ladderseo-control-wrapper">
                <div class ="col-3 ladderseo-control-label">
                <?php
                    $labelFor = $field_name;
                    $labelText = esc_html ($field_title);
                    $labelClass = array("form-label");
                    echo wp_kses($helper->ladderseoGetLabelField($labelText, $labelFor, $labelClass), $allowed_html);
                ?>
                </div>
                <div class ="col-9">
                <?php
                    $fieldName = $field_name;
                    $attr = Ladder_SEO_Util::get_field_attr($global_field_name);
                    $data = isset($settings["global"][$key][$global_field_name]) ? array($settings["global"][$key][$global_field_name]) : array();
                    $fieldClass = array();
                    $fieldData = Ladder_SEO_Util::get_field_data($global_field_name);
                    echo wp_kses($helper->ladderseoGetField($field_type, $fieldName, $attr, $data, $fieldData, $fieldClass), $allowed_html) ;
                ?>
                </div>
                <div class ="ladderseo-control-help">
                    <?php    
                    $divId = $field_name."_help";
                    $class = array("form-text");
                    $text = esc_html($help_text);
                    echo wp_kses($helper->ladderseoGetDiv($divId, $text, $class), $allowed_html);
                    ?>
                </div>
            </div>  
        </div>
        <?php }?>
            </div>
        </div>
        </div>
        </div>
        <?php }//end of foreach?>
    <div class="col-12 d-flex justify-content-end mt-3">
        <input type="submit"
        class="ladderseo-submit-button ladderseo-buttons ladderseo-save-settings btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light  me-3"
        id="ladderseo_save_global_settings" value="<?php esc_html_e('Save', 'ladder-seo') ?>" />
        <button type="reset" class="btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light">
            <?php esc_html_e('Reset', 'ladder-seo') ?>
        </button>
    </div>       
</form>