<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<div id="chartData" data-chart-data="<?php echo esc_attr(wp_json_encode($redirection_data["chart_data"])) ?>"></div>
<div class="row">
    <div class="col-xxl-3 col-xl-4 col-log-4 col-md-4 col-sm-12">
        <div class="card ladderseo-cards">
            <div class="card-body">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                    stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                    class="feather feather-book-open">
                    <path d="M2 3h6a4 4 0 0 1 4 4v14a3 3 0 0 0-3-3H2z"></path>
                    <path d="M22 3h-6a4 4 0 0 0-4 4v14a3 3 0 0 1 3-3h7z"></path>
                </svg>
                <h6 class="card-title fw-medium"><?php esc_html_e("Documentation", "ladder-seo"); ?></h6>
                <span class="card-text text-muted">
                    <?php esc_html_e("Get started by spending some time with the documentation to get familiar with Ladder SEO.", "ladder-seo"); ?>
                </span>

            </div>
            <div class="card-footer">
                <span class="card-text">
                    <a href="javascript:void(0);"
                        class="ladderseo-links"><?php esc_html_e("Documentation ->", "ladder-seo"); ?></a>
                </span>
            </div>
        </div>
    </div>

    <div class="col-xxl-3 col-xl-4 col-log-4 col-md-4 col-sm-12">
        <div class="card ladderseo-cards">
            <div class="card-body">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                    stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                    class="feather feather-help-circle">
                    <circle cx="12" cy="12" r="10"></circle>
                    <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"></path>
                    <line x1="12" y1="17" x2="12.01" y2="17"></line>
                </svg>
                <h6 class="card-title fw-medium"><?php esc_html_e("Help", "ladder-seo"); ?></h6>
                <span class="card-text text-muted">
                    <?php esc_html_e("Stuck with something? We are here to help you 24*7. Get help from live chat or support ticket.", "ladder-seo"); ?>
                </span>

            </div>
            <div class="card-footer">
                <span class="card-text">
                    <a href="javascript:void(0);"
                        class="ladderseo-links"><?php esc_html_e("Support ->", "ladder-seo"); ?></a>
                </span>
            </div>
        </div>
    </div>


    <div class="col-xxl-3 col-xl-4 col-log-4 col-md-4 col-sm-12">
        <div class="card ladderseo-cards">
            <div class="card-body">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                    stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                    class="feather feather-help-circle">
                    <circle cx="12" cy="12" r="10"></circle>
                    <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"></path>
                    <line x1="12" y1="17" x2="12.01" y2="17"></line>
                </svg>
                <h6 class="card-title fw-medium"><?php esc_html_e("FAQs", "ladder-seo"); ?></h6>
                <span class="card-text text-muted">
                    <?php esc_html_e("Got questions? This way please. FAQs, quick fixes, and official info on every feature.", "ladder-seo"); ?>
                </span>

            </div>
            <div class="card-footer">
                <span class="card-text">
                    <a href="<?php echo esc_url(get_site_url()."/faqs/") ?>"
                        class="ladderseo-links"><?php esc_html_e("FAQs ->", "ladder-seo"); ?></a>
                </span>
            </div>
        </div>
    </div>

</div>