<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<form id="ladderseo_content_form_settings" class="needs-validation ladderseo-forms" method="post" enctype="multipart/form-data">
    <?php wp_nonce_field('ladder_seo', 'ladder_seo_nonce'); ?>
    <?php $content_fields = isset($settings["content"])? $settings["content"]: array();?>
    <?php foreach($content_fields as $content_field_name => $content_field_val) { 
        $field_name = "ladderseo_content_".$content_field_name;
        $field_title = Ladder_SEO_Util::get_field_title($content_field_name);
        $field_type = Ladder_SEO_Util::get_field_type($content_field_name);
        $help_text = Ladder_SEO_Util::get_field_help_text($content_field_name);
        ?>
    <div class="col-12 ladderseo-content-settings">
        <div class = "row ladderseo-control-wrapper">
            <div class ="col-3 ladderseo-control-label">
        <?php
                $labelFor = $field_name;
                $labelText = esc_html($field_title);
                $labelClass = array("form-label");
                echo wp_kses($helper->ladderseoGetLabelField($labelText, $labelFor, $labelClass), $allowed_html);
        ?>
            </div>
            <div class ="col-9 ladderseo-control-field">
            <?php    
                $fieldName = $field_name;
                $attr = Ladder_SEO_Util::get_field_attr($content_field_name);
                $data = isset($settings["content"][$content_field_name]) ? array($settings["content"][$content_field_name]) : array();
                $fieldClass = array();
                $fieldData = Ladder_SEO_Util::get_field_data($content_field_name);
                echo wp_kses($helper->ladderseoGetField($field_type, $fieldName, $attr, $data, $fieldData, $fieldClass), $allowed_html) ;
                ?>

            </div>
            <div class ="ladderseo-control-help">
                    <?php    
                    $divId = $field_name."_help";
                    $class = array("form-text");
                    $text = esc_html($help_text);
                    echo wp_kses($helper->ladderseoGetDiv($divId, $text, $class), $allowed_html);
                    ?>
                </div>
        </div>  
    </div>
    <?php }//end of foreach ?>
    <div class="col-12 d-flex justify-content-end mt-3">
        <input type="submit"
        class="ladderseo-submit-button ladderseo-buttons ladderseo-save-settings btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light  me-3"
        id="ladderseo_save_content_settings" value="<?php esc_html_e('Save', 'ladder-seo') ?>" />
        <button type="reset" class="btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light">
            <?php esc_html_e('Reset', 'ladder-seo') ?>
        </button>
    </div>
   
</form>