<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<form id="ladderseo_taxonomy_form_settings" class="needs-validation ladderseo-forms" method="post" enctype="multipart/form-data">
<?php wp_nonce_field('ladder_seo', 'ladder_seo_nonce'); 

foreach ($taxonomies as $taxonomy) {
    ?>
<div class="row">
    <div class="col-xl-12">
        <div class="card ladderseo-cards overflow-hidden border">
            <div class="card-header justify-content-between border-bottom-0">
                <h5 class="mb-3"><?php echo esc_html(Ladder_SEO_Util::get_field_title($taxonomy)) ?></h5>
                <a href="javascript:void(0);" data-bs-toggle="collapse" data-bs-target="#ladderseo_<?php echo esc_html($taxonomy) ?>_settings"
                    aria-expanded="true" aria-controls="#ladderseo_<?php echo esc_html($taxonomy) ?>_settings">
                    <i class="ri-arrow-down-s-line fs-18 collapse-open">
                        <svg xmlns="http://www.w3.org/2000/svg"
                            width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                            stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-chevron-down">
                            <polyline points="6 9 12 15 18 9"></polyline>
                        </svg>
                    </i>
                    <i class="ri-arrow-up-s-line collapse-close fs-18">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-chevron-up">
                            <polyline points="18 15 12 9 6 15"></polyline>
                        </svg>
                    </i>
                </a>
            </div>
            <div class="card-body" id="ladderseo_<?php echo esc_html($taxonomy) ?>_settings">
                <ul class="nav nav-tabs mb-3 tab-style-8 scaleX" id="postTabs" role="tablist">
                <?php $active = "active";
                $content_types = isset($settings["content_types"]) ? $settings["content_types"] : array();?>                
                <?php foreach ($content_types as $tab => $content_type) {
                    ?>
                    <li class="nav-item" role="presentation"> 
                            <button class="nav-link <?php echo esc_html($active) ?>" id="<?php echo esc_html($tab."_".$taxonomy) ?>-tab"
                            data-bs-toggle="tab" data-bs-target="#<?php echo esc_html($tab."_".$taxonomy) ?>-pane" type="button" role="tab"
                            aria-controls="<?php echo esc_html($tab) ?>-tab-pane" aria-selected="true">
                            <?php echo esc_html(Ladder_SEO_Util::get_field_title($tab)) ?>
                        </button> 
                    </li>
                <?php  $active = "";
                } ?>    
                </ul>
                <div class="tab-content">
                <?php $active = "show active"; ?>                
                <?php foreach ($content_types as $tab => $content_type_fields) { ?>
                    <div class="tab-pane <?php echo esc_html($active) ?> overflow-hidden" id="<?php echo esc_html($tab."_".$taxonomy) ?>-pane" role="tabpanel"
                        aria-labelledby="<?php echo esc_html($tab."_".$taxonomy) ?>-tab" tabindex="0"> 
                        <?php
                        foreach ($content_type_fields as $content_type_field_name => $content_type_field_val) {
                            $field_name = "ladderseo_".$taxonomy."-".$content_type_field_name;
                            $field_title = Ladder_SEO_Util::get_field_title($content_type_field_name);
                            $help_text = Ladder_SEO_Util::get_field_help_text($content_type_field_name);
                            $field_type = Ladder_SEO_Util::get_field_type($content_type_field_name);
                            ?>
                          <div class="col-12 ladderseo-content_type-settings">
                            <div class = "row ladderseo-control-wrapper">
                                <div class ="col-3">
                                <?php
                                    $labelFor = $field_name;
                                    $labelText = esc_html($field_title);
                                    $labelClass = array("form-label");
                                    echo wp_kses($helper->ladderseoGetLabelField($labelText, $labelFor, $labelClass), $allowed_html);
                            ?>
                                </div>
                                <div class ="col-9">
                                <?php
                                $fieldName = $field_name;
                            $attr = Ladder_SEO_Util::get_field_attr($content_type_field_name);
                            $fieldData = Ladder_SEO_Util::get_field_data($content_type_field_name);
                            $data = isset($settings["term_types"][$taxonomy][$content_type_field_name]) ? array($settings["term_types"][$taxonomy][$content_type_field_name]) : array($settings["content_types"][$tab][$content_type_field_name]);
                            if ($field_type === "editor") {
                                $fieldClass = array("ladderseo-post-type-editor");
                            } else {
                                $fieldClass = array();
                            }
                            echo wp_kses($helper->ladderseoGetField($field_type, $fieldName, $attr, $data, $fieldData, $fieldClass), $allowed_html) ;
                            ?>
                                    <div class ="ladderseo-control-help">
                                    <?php
                            $divId = $field_name."_help";
                            $class = array("form-text");
                            $text = esc_html($help_text);
                            echo wp_kses($helper->ladderseoGetDiv($divId, $text, $class), $allowed_html);
                            ?>
                                    </div>
                                </div>
                            </div>  
                        </div>
                    <?php
                        }
                    ?>
                    </div>
                    <?php $active = "";
                } ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php } ?>
<div class="col-12 d-flex justify-content-end mt-3">
        <input type="submit"
        class="ladderseo-submit-button ladderseo-buttons ladderseo-save-settings btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light  me-3"
        id="ladderseo_save_post" value="<?php esc_html_e('Save', 'ladder-seo') ?>" />
        <button type="reset" class="btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light">
            <?php esc_html_e('Reset', 'ladder-seo') ?>
        </button>
    </div>    
</form>