<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<form id="ladderseo_bulk_term_form_settings" class="needs-validation ladderseo-forms" method="term" enctype="multipart/form-data">
    <?php wp_nonce_field('ladder_seo', 'ladder_seo_nonce'); ?>
    <table id ="ladderseo_bulk_tax" class="table table-striped table-hover ladderseo-bulk-update-table">
        <thead>
            <tr>
                <th scope="col"><?php esc_html_e("Title", "ladder-seo") ?></th>
                <th scope="col"><?php esc_html_e("Meta Data", "ladder-seo")  ?></th>
            </tr>
        </thead>
        <tbody>
            <?php 
            foreach($terms as $term) {
            $term_id = $term->term_id;
            $term_type = $term->taxonomy;
            ?>
            <tr id="row_bulk_term_<?php echo esc_html($term_id)?>">
                <th class="ladderseo-row-term-title" scope="row">
                    <?php echo esc_html($term->name);?>
                </th>
                <td class="ladderseo-row-meta-fields">
                <?php
                    $field = "meta_title";
                    $fieldName = "ladderseo_bulk_".$field."-".$term_type."-".$term_id;
                    $attr = array();
                    $data = isset($term_data[$term_id][$term_type][$field]) ? array($term_data[$term_id][$term_type][$field]) : array();
                    $fieldClass = array("ladderseo-bulk-meta-title");
                    echo wp_kses($helper->ladderseoGetInputField($fieldName, $attr,  $data, "text", $fieldClass), $allowed_html);

                    $field = "meta_description";
                    $fieldName = "ladderseo_bulk_".$field."-".$term_type."-".$term_id;
                    $attr = array();
                    $data = isset($term_data[$term_id][$term_type][$field]) ? array($term_data[$term_id][$term_type][$field]) : array();
                    $fieldClass = array("ladderseo-bulk-meta-description");
                    echo wp_kses($helper->ladderseoGetTextareaField($fieldName, $attr, $data, $fieldClass), $allowed_html);
                ?>
                </td>
            </tr>
            <?php } ?>
        </tbody>
    </table>
    <div class="col-12 d-flex justify-content-end mt-3">
        <input type="submit"
        class="ladderseo-submit-button ladderseo-buttons ladderseo-save-settings btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light  me-3"
        id="ladderseo_save_bulk_term_settings" value="<?php esc_html_e('Save', 'ladder-seo') ?>" />
        <button type="reset" class="btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light">
            <?php esc_html_e('Reset', 'ladder-seo') ?>
        </button>
    </div>     
</form>