<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<form id="ladderseo_bulk_post_form_settings" class="needs-validation ladderseo-forms" method="post" enctype="multipart/form-data">
    <?php wp_nonce_field('ladder_seo', 'ladder_seo_nonce'); ?>

    <table id ="ladderseo_bulk_post" class="table table-striped table-hover ladderseo-bulk-update-table">
        <thead>
            <tr>
                <th scope="col"><?php esc_html_e("Post Title", "ladder-seo") ?></th>
                <th scope="col"><?php esc_html_e("Meta Data", "ladder-seo")  ?></th>
            </tr>
        </thead>
        <tbody>
            <?php 
            foreach($posts as $post) {
            $post_id = $post->ID;
            $post_type = $post->post_type;
            ?>
            <tr id="row_bulk_post_<?php echo esc_html($post_id) ?>">
                <th class="ladderseo-row-post-title" scope="row">
                    <a href =<?php echo esc_url(get_permalink($post->ID))?> title ="<?php echo esc_html($post->post_title);?>">
                        <?php echo esc_html(Ladder_SEO_Util::ladderseo_truncate_string($post->post_title));?>
                    </a>
                </th>
                <td class="ladderseo-row-meta-fields">
                <?php
                    $field = "meta_title";
                    $fieldName = "ladderseo_bulk_".$field."-".$post_type."-".$post_id;
                    $attr = array();
                    $data = isset($post_data[$post_id][$post_type][$field]) ? array($post_data[$post_id][$post_type][$field]) : array();
                    $fieldClass = array("ladderseo-bulk-meta-title");
                    echo wp_kses($helper->ladderseoGetInputField($fieldName, $attr,  $data, "text", $fieldClass), $allowed_html);

                    $field = "meta_description";
                    $fieldName = "ladderseo_bulk_".$field."-".$post_type."-".$post_id;
                    $attr = array();
                    $data = isset($post_data[$post_id][$post_type][$field]) ? array($post_data[$post_id][$post_type][$field]) : array();
                    $fieldClass = array("ladderseo-bulk-meta-description");
                    echo wp_kses($helper->ladderseoGetTextareaField($fieldName, $attr, $data, $fieldClass), $allowed_html);
                ?>
                </td>
            </tr>
            <?php } ?>
        </tbody>
    </table>    
    <div class="col-12 d-flex justify-content-end mt-3">
        <input type="submit"
        class="ladderseo-submit-button ladderseo-buttons ladderseo-save-settings btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light  me-3"
        id="ladderseo_save_bulk_post_settings" value="<?php esc_html_e('Save', 'ladder-seo') ?>" />
        <button type="reset" class="btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light">
            <?php esc_html_e('Reset', 'ladder-seo') ?>
        </button>
    </div>  
        
</form>