<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<!-- Modal -->
<div class="modal fade" id="ladderseo_bulk_popup" tabindex="-1" aria-labelledby="ladderseo_bulk_popup_Label" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="ladderseo_bulk_popup_Label">
                    <?php esc_html_e("Bulk Action","ladder-seo") ?>
                </h1>
                <button type="button" class="btn-close ladderseo-buttons " data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="card ladderseo-cards">
                    <div class="card-header">
                        <h5 class="card-title">
                            <?php esc_html_e("Meta Title","ladder-seo") ?>
                        </h5>
                    </div>
                    <div class="card-body">
                        <?php
                        $fieldName = "ladderseo_meta_title_actions";
                        $attr = array();
                        $fieldData = array(
                            array("no_action" ,__("No action", "ladder-seo")),
                            array("copy_title" ,__("Copy title to generate 'Meta Title'", "ladder-seo")),
                        );
                        $data = array();
                        $fieldClass = array("ladderseo-bulk-actions");
                        $allowed_html = Ladder_SEO_Util::get_allowed_html();
                        echo wp_kses( $helper->ladderseoGetRadioButtonField($fieldName, $attr, $data, $fieldData, $fieldClass), $allowed_html);
                        ?>
                    </div>
                </div>
                <div class="card ladderseo-cards">
                    <div class="card-header">
                        <h5 class="card-title">
                            <?php esc_html_e("Meta Description","ladder-seo") ?>
                        </h5>
                    </div>
                    <div class="card-body">
                        <?php
                        $fieldName = "ladderseo_meta_description_actions";
                        $attr = array();
                        $fieldData = array(
                            array("no_action" ,__("No action", "ladder-seo")),
                            array("copy_title" ,__("Copy title to generate 'Meta Description'", "ladder-seo")),
                        );
                        $data = array();
                        $fieldClass = array("ladderseo-bulk-actions");
                        $allowed_html = Ladder_SEO_Util::get_allowed_html();
                        echo wp_kses( $helper->ladderseoGetRadioButtonField($fieldName, $attr, $data, $fieldData, $fieldClass), $allowed_html );
                        ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary ladderseo-buttons " data-bs-dismiss="modal"> <?php esc_html_e("Close","ladder-seo") ?></button>
                <button type="button" class="btn btn-primary ladderseo-buttons " id="ladderseo_bulk_action_apply"> <?php esc_html_e("Apply changes","ladder-seo") ?></button>
            </div>
        </div>
    </div>
</div>