<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<form id="ladderseo_ai_form_settings" class="needs-validation ladderseo-forms" method="post" enctype="multipart/form-data">
    <?php wp_nonce_field('ladder_seo', 'ladder_seo_nonce'); ?>

    <div class="col-12 ladderseo-seo-ai-settings">
        <?php
                $labelFor = "ladderseo_ai_llm";
                $labelText =  esc_html__("Large Language Model", "ladder-seo");
                $labelClass = array("form-label");
                echo wp_kses($helper->ladderseoGetLabelField($labelText, $labelFor, $labelClass), $allowed_html);

                //AI LLM
                $fieldName = "ladderseo_ai_llm";
                $attr = array();
                $placeholder =  esc_html__('Select LLM', 'ladder-seo');
                $data = isset($settings["ai"]["llm"])? array($settings["ai"]["llm"]) : array();
                $option0 = array("none", $placeholder);
                $option1 = array("chatgpt",esc_html__('ChatGPT', 'ladder-seo'));
                $option2 = array("gemini",esc_html__('Google Gemini', 'ladder-seo'));               
                
                $fieldData = array($option0, $option1, $option2);
                echo wp_kses($helper->ladderseoGetSelectField($fieldName, $attr, $data, $fieldData), $allowed_html);        

                $divId = "ladderseo_ai_llm_help";
                $class = array("form-text");
                $text = esc_html__("Select LLM to be used for AI operations", "ladder-seo");
                echo wp_kses($helper->ladderseoGetDiv($divId, $text, $class), $allowed_html);
                ?>
    </div>
    <div class="col-12 ladderseo-seo-ai-settings">
        <?php
                $labelFor = "ladderseo_ai_model";
                $labelText =  esc_html__("Model name", "ladder-seo");
                $labelClass = array("form-label");
                echo wp_kses($helper->ladderseoGetLabelField($labelText, $labelFor, $labelClass), $allowed_html);

                //AI Model
                $fieldName = "ladderseo_ai_model";
                $attr = array( );
                $data = isset($settings["ai"]["model"])? array($settings["ai"]["model"]) : array();
                $fieldClass = array();
                echo wp_kses($helper->ladderseoGetInputField($fieldName, $attr,  $data, "text", $fieldClass), $allowed_html);
      
                $divId = "ladderseo_ai_model_help";
                $class = array("form-text");
                $text = esc_html__("Select model e.g gpt-3.5-turbo, gpt-4", "ladder-seo");
                echo wp_kses($helper->ladderseoGetDiv($divId, $text, $class), $allowed_html);
                ?>
    </div>
    <div class="col-12  kivo-form-fields ks-search-ai-settings">
        <?php
                $labelFor = "ladderseo_ai_maxtokens";
                $labelText =  esc_html__("Max tokens", "ladder-seo");
                $labelClass = array("form-label");
                echo wp_kses($helper->ladderseoGetLabelField($labelText, $labelFor, $labelClass), $allowed_html);

                //AI max tokens
                $fieldName = "ladderseo_ai_maxtokens";
                $attr = array( );
                $data = isset($settings["ai"]["maxtokens"])? array($settings["ai"]["maxtokens"]) : array();
                $fieldClass = array();
                echo wp_kses($helper->ladderseoGetInputField($fieldName, $attr,  $data, "text", $fieldClass), $allowed_html);
      
                $divId = "ladderseo_ai_maxtokens_help";
                $class = array("form-text");
                $text = esc_html__("Maximum number of tokens to be sent for each AI call", "ladder-seo");
                echo wp_kses($helper->ladderseoGetDiv($divId, $text, $class), $allowed_html);
                ?>
    </div>
    <div class="col-12  kivo-form-fields ks-search-ai-settings">
        <?php
                $labelFor = "ladderseo_ai_temperature";
                $labelText =  esc_html__("Temperature", "ladder-seo");
                $labelClass = array("form-label");
                echo wp_kses($helper->ladderseoGetLabelField($labelText, $labelFor, $labelClass), $allowed_html);

                //AI Model
                $fieldName = "ladderseo_ai_temperature";
                $attr = array( );
                $data = isset($settings["ai"]["temperature"])? array($settings["ai"]["temperature"]) : array();
                $fieldClass = array();
                echo wp_kses($helper->ladderseoGetInputField($fieldName, $attr,  $data, "text", $fieldClass), $allowed_html);
      
                $divId = "ladderseo_ai_temperature_help";
                $class = array("form-text");
                $text = esc_html__("Set temperature for the model", "ladder-seo");
                echo wp_kses($helper->ladderseoGetDiv($divId, $text, $class), $allowed_html);
                ?>
    </div>
    <div class="col-12 ladderseo-seo-ai-settings">
        <?php
                $labelFor = "ladderseo_ai_key";
                $labelText =  esc_html__("AI Secret key", "ladder-seo");
                $labelClass = array("form-label");
                echo wp_kses($helper->ladderseoGetLabelField($labelText, $labelFor, $labelClass), $allowed_html);

                //API Secret Key
                $fieldName = "ladderseo_ai_key";
                $attr = array( );
                $data = isset($settings["ai"]["key"])? array($settings["ai"]["key"]) : array();
                $fieldClass = array();
                echo wp_kses($helper->ladderseoGetInputField($fieldName, $attr,  $data, "text", $fieldClass), $allowed_html) ;             
      
                $divId = "ladderseo_ai_key_help";
                $class = array("form-text");
                $text = esc_html__("API Secret Key", "ladder-seo");
                echo wp_kses($helper->ladderseoGetDiv($divId, $text, $class), $allowed_html);
                ?>
    </div>
    <div class="col-12 d-flex justify-content-end mt-3">
        <input type="submit"
            class="ladderseo-submit-button ladderseo-buttons ladderseo-save-settings btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light  me-3"
            id="ladderseo_save_ai_settings" value="<?php esc_html_e('Save', 'ladder-seo') ?>" />
        <button type="reset" class="btn btn-secondary btn-rgeneralsed-shadow btn-wave waves-effect waves-light">
            <?php esc_html_e('Reset', 'ladder-seo') ?>
        </button>
    </div>
</form>