(function( $ ) {
	'use strict';

	jQuery.ladderSEOActions = {
		
		init: function () {
			jQuery(document).ready(function() {
				jQuery('.ladderseo-select2').select2( {width: '100%'});
				jQuery.ladderSEOActions.initializeDatatables();
			});
			// open wordpress media manager
			jQuery(document).on("click", ".ladderseo-open-media, .ladderseo-replace-image", function (e) {
                e.preventDefault();

                var $upload_button = jQuery(this);
                //Extend the wp.media object
                var custom_uploader = wp.media.frames.file_frame = wp.media({
                    title: 'Choose Image',
                    button: {
                        text: 'Choose Image'
                    },
                    multiple: false
                });

                //When a file is selected, grab the URL and set it as the text field's value
                custom_uploader.on('select', function() {
                    var attachment = custom_uploader.state().get('selection').first().toJSON();
                    $upload_button.parent().find('input[type="hidden"]').val(attachment.url);
                    $upload_button.parent().find('img').attr("src",attachment.url);
                });

                //Open the uploader dialog
                custom_uploader.open();
            });

            jQuery(document).on("click",".ladderseo-delete-media", function (e) {
                e.preventDefault();
                jQuery(this).parent().find('input[type="hidden"]').val("");
                jQuery(this).parent().find('img').attr("src","");
            });

			jQuery(document).on("click",".ladderseo-delete-redirection", function (e) {
                e.preventDefault();
				var id = jQuery(this).data("id");
				const nonce = document.getElementById("ladder_seo_nonce").value;
				var formData = new FormData();
                formData.append('action', 'ladder_seo_admin_ajax');
				formData.append('action_type', 'delete_redirection');
				formData.append('form_type', 'redirection');
				formData.append('id', id);
				formData.append("ladder_seo_nonce", nonce);
                jQuery.ladderSEOActions.saveSettings(formData);
            });

			
			
			jQuery(document).on('change', '.ladderseo__toggle__input', function (evt) {
                if(jQuery(this).is(':checked'))
                	jQuery(this).parent(".ladderseo__toggle").next(".ladderseo__toggle_span").html("Enabled");
				else 
					jQuery(this).parent(".ladderseo__toggle").next(".ladderseo__toggle_span").html("Disabled");
            });

			jQuery(document).on('submit', '#ladderseo_ai_form_settings', function (evt) {
                evt.preventDefault();
                var formData = new FormData(this);
                formData.append('action', 'ladder_seo_admin_ajax');
				formData.append('action_type', 'save_ai_settings');
				formData.append('form_type', 'ai');
                jQuery.ladderSEOActions.saveSettings(formData);
            });

			jQuery(document).on('submit', '#ladderseo_license_form_settings', function (evt) {
                evt.preventDefault();
                var formData = new FormData(this);
                formData.append('action', 'ladder_seo_admin_ajax');
				formData.append('action_type', 'save_license_settings');
				formData.append('form_type', 'license');
                jQuery.ladderSEOActions.saveSettings(formData);
            });

			jQuery(document).on('submit', '#ladderseo_general_form_settings', function (evt) {
                evt.preventDefault();
                var formData = new FormData(this);
                formData.append('action', 'ladder_seo_admin_ajax');
				formData.append('action_type', 'save_general_settings');
				formData.append('form_type', 'general');
                jQuery.ladderSEOActions.saveSettings(formData);
            });

			jQuery(document).on('submit', '#ladderseo_w3c_form_settings', function (evt) {
                evt.preventDefault();
                var formData = new FormData(this);
                formData.append('action', 'ladder_seo_admin_ajax');
				formData.append('action_type', 'save_w3c_settings');
				formData.append('form_type', 'w3c');
                jQuery.ladderSEOActions.saveSettings(formData);
            });

			jQuery(document).on('submit', '#ladderseo_optimization_form_settings', function (evt) {
                evt.preventDefault();
                var formData = new FormData(this);
                formData.append('action', 'ladder_seo_admin_ajax');
				formData.append('action_type', 'save_optimization_settings');
				formData.append('form_type', 'optimization');
                jQuery.ladderSEOActions.saveSettings(formData);
            });

			jQuery(document).on('submit', '#ladderseo_bulk_post_form_settings', function (evt) {
                evt.preventDefault();
                var formData = new FormData(this);
                formData.append('action', 'ladder_seo_admin_ajax');
				formData.append('action_type', 'save_bulk_data_settings');
				formData.append('form_type', 'bulk_post');
                jQuery.ladderSEOActions.saveSettings(formData);
            });

			jQuery(document).on('submit', '#ladderseo_social_form_settings', function (evt) {
                evt.preventDefault();
                var formData = new FormData(this);
                formData.append('action', 'ladder_seo_admin_ajax');
				formData.append('action_type', 'save_social_settings');
				formData.append('form_type', 'social');
                jQuery.ladderSEOActions.saveSettings(formData);
            });

			jQuery(document).on('submit', '#ladderseo_redirection_form_settings', function (evt) {
                evt.preventDefault();
                var formData = new FormData(this);
                formData.append('action', 'ladder_seo_admin_ajax');
				formData.append('action_type', 'save_redirection');
				formData.append('form_type', 'redirection');
                jQuery.ladderSEOActions.saveSettings(formData);
            });

			jQuery(document).on('submit', '#ladderseo_analytics_form_settings', function (evt) {
                evt.preventDefault();
                var formData = new FormData(this);
                formData.append('action', 'ladder_seo_admin_ajax');
				formData.append('action_type', 'save_webmaster_analytics');
				formData.append('form_type', 'webmaster_analytics');
                jQuery.ladderSEOActions.saveSettings(formData);
            });


			jQuery(document).on('submit', '#ladderseo_post_type_form_settings', function (evt) {
                evt.preventDefault();
                var formData = new FormData(this);
                formData.append('action', 'ladder_seo_admin_ajax');
				formData.append('action_type', 'save_post_types');
				formData.append('form_type', 'content_types');
				var editorId = "";
				jQuery(".ladderseo-post-type-editor").each(function(){
					editorId = jQuery(this).attr("id");
					formData.append(editorId, editors[editorId].getText());
				});
				
                jQuery.ladderSEOActions.saveSettings(formData);
            });

			jQuery(document).on('submit', '#ladderseo_taxonomy_form_settings', function (evt) {
                evt.preventDefault();
                var formData = new FormData(this);
                formData.append('action', 'ladder_seo_admin_ajax');
				formData.append('action_type', 'save_taxonomy_types');
				formData.append('form_type', 'content_types');
				var editorId = "";
				jQuery(".ladderseo-post-type-editor").each(function(){
					editorId = jQuery(this).attr("id");
					formData.append(editorId, editors[editorId].getText());
				});
				
                jQuery.ladderSEOActions.saveSettings(formData);
            });

			jQuery(document).on('submit', '#ladderseo_global_form_settings', function (evt) {				
                evt.preventDefault();
                var formData = new FormData(this);
                formData.append('action', 'ladder_seo_admin_ajax');
				formData.append('action_type', 'save_global_settings');
				formData.append('ladderseo_global_home_title', editors["ladderseo_global_home_title"].getText());
				formData.append('ladderseo_global_home_description', editors["ladderseo_global_home_description"].getText());
				formData.append('form_type', 'global');
                jQuery.ladderSEOActions.saveSettings(formData);
            });

			jQuery(document).on('submit', '#ladderseo_content_form_settings', function (evt) {				
                evt.preventDefault();
                var formData = new FormData(this);
                formData.append('action', 'ladder_seo_admin_ajax');
				formData.append('action_type', 'save_content_settings');
				formData.append('form_type', 'content');
                jQuery.ladderSEOActions.saveSettings(formData);
            });

			jQuery(document).on('submit', '#ladderseo_keyword_form_settings', function (evt) {				
                evt.preventDefault();
				if (ladderseo_keyword === '') {
					alert('Please enter a keyword.');
					return;
				}
                var formData = new FormData(this);
                formData.append('action', 'ladder_seo_admin_ajax');
				formData.append('action_type', 'ladderseo_get_high_traffic_keywords');
				formData.append('form_type', 'keywords');
                jQuery.ladderSEOActions.getKeywords(formData);
            });

			jQuery(document).on('click', '#ladderseo_get_long_tail_keywords', function (evt) {				
                evt.preventDefault();
				var ladder_seo_nonce = jQuery("#ladder_seo_nonce").val();
				var ladderseo_keyword = jQuery("#ladderseo_keyword").val();
				if (ladderseo_keyword === '') {
					alert('Please enter a keyword.');
					return;
				}
                var formData = new FormData();
                formData.append('action', 'ladder_seo_admin_ajax');
				formData.append('action_type', 'ladderseo_get_long_tail_keywords');
				formData.append('form_type', 'keywords');
				formData.append('ladderseo_keyword', ladderseo_keyword);
				formData.append('ladder_seo_nonce', ladder_seo_nonce);
                jQuery.ladderSEOActions.getKeywords(formData);
            });

			jQuery(document).on("click","#ladderseo_bulk_action_apply", function (evt) {				
                evt.preventDefault();
				var action_type = jQuery('input[name="ladderseo_meta_title_actions"]:checked').val();
				var active_class_tax = jQuery('#ladderseo-bulk-taxonomy-tab').hasClass("active");
				var content_type = "post";

				if(active_class_tax)
					content_type = "tax";
				else
					content_type = "post";
				
				if(action_type === "copy_title"){
					jQuery.ladderSEOActions.copyField("title", content_type);
				}

				action_type = jQuery('input[name="ladderseo_meta_description_actions"]:checked').val();
				if(action_type === "copy_title"){
					jQuery.ladderSEOActions.copyField("description", content_type);
				}

			});
		},
		initializeDatatables: function(){
			var table = jQuery('.ladderseo-bulk-update-table').DataTable({
				pageLength: 5,
				layout: {
					topStart: null,
					bottomStart: null,
					bottomEnd: 'paging',
				},
			  });	

		},
		copyField: function(type, content_type){		
			if(content_type === "post")	
				jQuery.ladderSEOActions.copyFieldPost(type);
			else if(content_type === "tax")	
				jQuery.ladderSEOActions.copyFieldTax(type);
				
		},
		copyFieldPost: function(type){
			var table = jQuery('#ladderseo_bulk_post').DataTable();
			var post_title = "";
			var rowNode;
			if(type === "title"){
				var post_title = "";
				table.rows().every(function() {
					rowNode = this.node(); // get the DOM node for the row
					post_title = jQuery(rowNode).find('th:eq(0)').text().trim();  // Get value from the first column
					jQuery(rowNode).find('input[type="text"]').val(post_title);
				});	
			}
			else if(type === "description"){
				table.rows().every(function() {
					rowNode = this.node(); // get the DOM node for the row
					post_title = jQuery(rowNode).find('th:eq(0)').text().trim();  // Get value from the first column
					jQuery(rowNode).find('textarea').val(post_title);
				});
			}
		},
		copyFieldTax : function(type){
			var table = jQuery('#ladderseo_bulk_tax').DataTable();
			var post_title = "";
			var rowNode;

			if(type === "title"){
				table.rows().every(function() {
					rowNode = this.node(); // get the DOM node for the row
					post_title = jQuery(rowNode).find('th:eq(0)').text().trim();  // Get value from the first column
					jQuery(rowNode).find('input[type="text"]').val(post_title);
				});
			}
			else if(type === "description"){

				table.rows().every(function() {
					rowNode = this.node(); // get the DOM node for the row
					post_title = jQuery(rowNode).find('th:eq(0)').text().trim();  // Get value from the first column
					jQuery(rowNode).find('textarea').val(post_title);
				});
			}
		},
		saveSettings: function (formData) {

			jQuery.ajax({
				type: 'POST',
				url: ajaxurl,
				data: formData,
				processData: false,
				contentType: false,
				cache: false,
				beforeSend: function () {
					jQuery(".ladder-seo-ajax-loading-gif").show();
				},
				success: function (response) {
					jQuery(".ladder-seo-ajax-loading-gif").hide();
					jQuery.ladderSEOActions.showAlert('success');
				},
				complete: function (response) {
					jQuery(".ladder-seo-ajax-loading-gif").hide();
				},
				error: function (response) {
					jQuery(".ladder-seo-ajax-loading-gif").hide();
					jQuery.ladderSEOActions.showAlert('danger');
				}
			});
			
		},
		getKeywords: function (formData) {

			jQuery.ajax({
				type: 'POST',
				url: ajaxurl,
				data: formData,
				processData: false,
				contentType: false,
				cache: false,
				beforeSend: function () {
					jQuery(".ladder-seo-ajax-loading-gif").show();
				},
				success: function (response) {
					jQuery(".ladder-seo-ajax-loading-gif").hide();
					jQuery.ladderSEOActions.showAlert('success');
					jQuery("#ladderseo_keyword_output").html(response.data.message);
				},
				complete: function (response) {
					jQuery(".ladder-seo-ajax-loading-gif").hide();
				},
				error: function (response) {
					jQuery(".ladder-seo-ajax-loading-gif").hide();
					jQuery.ladderSEOActions.showAlert('danger');
				}
			});
			
		},
		showAlert: function(type) {
			jQuery('#ladder-seo-alert-message').removeClass('alert-success alert-danger').addClass('alert-' + type);
			jQuery('.ladder-seo-alert-message-content').hide();
			jQuery('#ladder-seo-alert-message-'+type+'-content').show();
			jQuery('#ladder-seo-alert-message').fadeIn(500).delay(3000).fadeOut(500);
		  },
	};
	jQuery.ladderSEOActions.init();
})(jQuery);