document.addEventListener('DOMContentLoaded', () => {

    const radioContentGeneratorTypes = document.querySelectorAll('input[name="ladderseo_content_generation_type"]');

    radioContentGeneratorTypes.forEach((radio) => {
        radio.addEventListener('change', function () {
            document.getElementById("ladderseo_ai_action_spin").classList.add("ladderseo-hide");
            document.getElementById("ladderseo_div_generate_title_content").classList.add("ladderseo-hide");

            if (this.checked) {
                if (this.value === 'title_and_content') {
                    document.getElementById("ladderseo_div_generate_title_content").classList.remove("ladderseo-hide");
                } else if (this.value === 'regenerate') {
                    document.getElementById("ladderseo_ai_action_spin").classList.remove("ladderseo-hide");
                }
            }
        });
    });

    document.getElementById("ladderseo_generate_meta_title").addEventListener("click", function () {
        const currentElement = this;
        get_data_using_ai("ladderseo_get_meta_title", currentElement);
    });

    document.getElementById("ladderseo_generate_meta_description").addEventListener("click", function () {
        const currentElement = this;
        get_data_using_ai("ladderseo_get_meta_description", currentElement);
    });

    document.getElementById("ladderseo_ai_action_generate_title_content").addEventListener("click", function () {
        const currentElement = this;
        get_data_using_ai("ladderseo_ai_action_generate_title_content", currentElement);
    });

    document.getElementById("ladderseo_ai_action_regenerate").addEventListener("click", function () {
        const currentElement = this;
        get_data_using_ai("ladderseo_ai_action_regenerate", currentElement);
    });

    document.getElementById("ladderseo_get_resources").addEventListener("click", function () {
        getResourceData();
    });

    document.getElementById("ladderseo_ai_action_spin").addEventListener("click", function () {
        const currentElement = this;

        const postTitle = getPostTitle();
        const postContent = getPostContent();

        document.getElementById('ladderseo_generated_title').value = postTitle;
        document.getElementById('ladderseo_generated_description').value = postContent;

        get_data_using_ai("ladderseo_ai_action_spin", currentElement);
    });

    document.getElementById("ladderseo_use_content").addEventListener("click", function () {
        const title = document.getElementById('ladderseo_generated_title').value;
        const content = document.getElementById('ladderseo_generated_description').value;

        setPostTitle(title);
        setPostContent(content);
    });

    function get_data_using_ai(action_type, currentElement) {
        const nonce = document.getElementById("ladder_seo_nonce").value;
        const keywords = document.getElementById("ladderseo_keywords").value;
        const briefDescription = document.getElementById("ladderseo_brief_description").value;
        const description = document.getElementById("ladderseo_generated_description").value;
        const title = document.getElementById("ladderseo_generated_title").value;
        const url = window.location.href;
        const urlObj = new URL(url);
        const id = currentElement.id;

        const params = new URLSearchParams(urlObj.search);

        if (params.has("post")) {
            const xhr = new XMLHttpRequest();
            const data = new FormData();
            const post_id = params.get("post");

            data.append("action", "ladder_seo_admin_ajax");
            data.append("action_type", action_type);
            data.append("type", "ai");
            data.append("ladder_seo_nonce", nonce);
            data.append("post_id", post_id);
            data.append("content_type", "post");
            data.append("keywords", keywords);
            data.append("brief_description", briefDescription);
            data.append("description", description);
            data.append("title", title);

            const targetElement = currentElement.previousElementSibling;

            xhr.open("POST", ajaxurl, true);
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    const response = JSON.parse(xhr.responseText);
                    if (response.success) {
                        if (id === "ladderseo_ai_action_generate_title_content" || id === "ladderseo_ai_action_spin" || id === "ladderseo_ai_action_regenerate") {
                            document.getElementById('ladderseo_generated_title').value = response.data.message.ladderseo_title;
                            document.getElementById('ladderseo_generated_description').value = response.data.message.ladderseo_content;
                        } else {
                            targetElement.value = response.data.message;
                        }
                    } else {
                        alert("Error: " + response.data.message);
                    }
                }
            };
            xhr.send(data);
        } else {
            alert("You must save the post to get the data using AI");
        }
    }

    const tabs = document.querySelectorAll('.ladderseo-meta-box-tabs li a');
    const tabContents = document.querySelectorAll('.ladderseo-tab-content');

    tabs.forEach(tab => {
        tab.addEventListener('click', event => {
            event.preventDefault();
            const target = document.querySelector(tab.getAttribute('href'));

            tabs.forEach(t => t.classList.remove('ladderseo-active'));
            tabContents.forEach(tc => tc.classList.remove('ladderseo-active'));

            tab.classList.add('ladderseo-active');
            target.classList.add('ladderseo-active');
        });
    });

    if (tabs.length > 0) {
        tabs[0].click();
    }
});

// Helpers to detect and manage Classic vs Gutenberg Editor

function isGutenbergEditor() {
    const isEditScreen = (
        window.location.pathname.includes('post.php') || 
        window.location.pathname.includes('post-new.php')
    );

    if (!isEditScreen) {
        return false;
    }

    const body = document.body;

    if (body.classList.contains('block-editor-page')) {
        return true;
    }

    return false;
}


function getPostTitle() {
    if (isGutenbergEditor()) {
        return wp.data.select('core/editor').getEditedPostAttribute('title');
    } else {
        const titleInput = document.getElementById('title');
        return titleInput ? titleInput.value : '';
    }
}

function getPostContent() {
    if (isGutenbergEditor()) {
        return wp.data.select('core/editor').getEditedPostAttribute('content');
    } else {
        if (typeof tinyMCE !== 'undefined' && tinyMCE.get('content')) {
            return tinyMCE.get('content').getContent();
        } else {
            const textarea = document.getElementById('content');
            return textarea ? textarea.value : '';
        }
    }
}

function setPostTitle(title) {
    if (isGutenbergEditor()) {
        wp.data.dispatch('core/editor').editPost({ title: title });
    } else {
        const titleInput = document.getElementById('title');
        if (titleInput) {
            titleInput.value = title;
        }
    }
}

function setPostContent(content) {
    if (isGutenbergEditor()) {
        wp.data.dispatch('core/editor').editPost({ content: content });
    } else {
        if (typeof tinyMCE !== 'undefined' && tinyMCE.get('content')) {
            tinyMCE.get('content').setContent(content);
        } else {
            const textarea = document.getElementById('content');
            if (textarea) {
                textarea.value = content;
            }
        }
    }
}

function getResourceData(){
    const API_KEY = '49216769-3fa39c27ca7afa9b21bec7926'; // Replace with your actual API key
    const query = document.getElementById('ladderseo_resources').value;
    const URL = `https://pixabay.com/api/?key=${API_KEY}&q=${encodeURIComponent(query)}`;

    fetch(URL)
    .then(response => response.json())
    .then(data => {
        if (parseInt(data.totalHits) > 0) {
        const gallery = document.getElementById('ladderseo-gallery');
        gallery.innerHTML = ''; // Clear previous content

        data.hits.forEach(hit => {
            const img = document.createElement('img');
            img.src = hit.previewURL;
            img.alt = hit.tags;
            img.title = hit.tags;
            img.style.margin = '10px';
            img.style.width = '150px'; // Fixed width thumbnail
            img.style.borderRadius = '8px';
            img.style.boxShadow = '0 2px 8px rgba(0,0,0,0.2)';
            img.onclick = () => window.open(hit.pageURL, '_blank'); // Open full page on click

            gallery.appendChild(img);
        });
        } else {
        console.log('No hits');
        document.getElementById('ladderseo-gallery').textContent = 'No results found.';
        }
    })
    .catch(error => {
        console.error('Error fetching data:', error);
        document.getElementById('ladderseo-gallery').textContent = 'Failed to fetch images.';
    });

    }

// Meta Image Uploader (unchanged from your original)

document.addEventListener("DOMContentLoaded", () => {
    document.addEventListener("click", (e) => {
        if (e.target.classList.contains("ladderseo-open-media") || e.target.classList.contains("ladderseo-replace-image")) {
            e.preventDefault();
            const uploadButton = e.target;
            const customUploader = wp.media({
                title: "Choose Image",
                button: { text: "Choose Image" },
                multiple: false
            });
            customUploader.on("select", () => {
                const attachment = customUploader.state().get("selection").first().toJSON();
                const parent = uploadButton.parentElement;
                parent.querySelector('input[type="hidden"]').value = attachment.url;
                parent.querySelector('img').setAttribute("src", attachment.url);
            });
            customUploader.open();
        }
    });

    document.addEventListener("click", (e) => {
        if (e.target.classList.contains("ladderseo-delete-media")) {
            e.preventDefault();
            const parent = e.target.parentElement;
            parent.querySelector('input[type="hidden"]').value = "";
            parent.querySelector('img').setAttribute("src", "");
        }
    });

    document.addEventListener("change", (e) => {
        if (e.target.classList.contains("ladderseo__toggle__input")) {
            const toggleSpan = e.target.parentElement.nextElementSibling;
            toggleSpan.innerHTML = e.target.checked ? "Enabled" : "Disabled";
        }
    });
});
