document.addEventListener('DOMContentLoaded', () => {

    const tabs = document.querySelectorAll('.ladderseo-meta-box-tabs li a');
    const tabContents = document.querySelectorAll('.ladderseo-tab-content');

    tabs.forEach(tab => {
        tab.addEventListener('click', event => {
            event.preventDefault();
            const target = document.querySelector(tab.getAttribute('href'));

            tabs.forEach(t => t.classList.remove('ladderseo-active'));
            tabContents.forEach(tc => tc.classList.remove('ladderseo-active'));

            tab.classList.add('ladderseo-active');
            target.classList.add('ladderseo-active');
        });
    });

    if (tabs.length > 0) {
        tabs[0].click();
    }
});


// Meta Image Uploader (unchanged from your original)

document.addEventListener("DOMContentLoaded", () => {
    document.addEventListener("click", (e) => {
        if (e.target.classList.contains("ladderseo-open-media") || e.target.classList.contains("ladderseo-replace-image")) {
            e.preventDefault();
            const uploadButton = e.target;
            const customUploader = wp.media({
                title: "Choose Image",
                button: { text: "Choose Image" },
                multiple: false
            });
            customUploader.on("select", () => {
                const attachment = customUploader.state().get("selection").first().toJSON();
                const parent = uploadButton.parentElement;
                parent.querySelector('input[type="hidden"]').value = attachment.url;
                parent.querySelector('img').setAttribute("src", attachment.url);
            });
            customUploader.open();
        }
    });

    document.addEventListener("click", (e) => {
        if (e.target.classList.contains("ladderseo-delete-media")) {
            e.preventDefault();
            const parent = e.target.parentElement;
            parent.querySelector('input[type="hidden"]').value = "";
            parent.querySelector('img').setAttribute("src", "");
        }
    });

    document.addEventListener("change", (e) => {
        if (e.target.classList.contains("ladderseo__toggle__input")) {
            const toggleSpan = e.target.parentElement.nextElementSibling;
            toggleSpan.innerHTML = e.target.checked ? "Enabled" : "Disabled";
        }
    });
});
