document.addEventListener('DOMContentLoaded', function () {
    const tags = ['site_title', 'tagline', 'post_title', 'page_description', 'separator', 'post_description', 'post_excerpt', 'term_name', 'author_name', 'author_first_name', 'author_last_name', 'current_month', 'current_year', 'post_date', 'current_date', 'current_day'];
    const dropdown = document.getElementById('ladderseo-tags-dropdown');
    const tagsList = document.getElementById('ladderseo-tags-list');

    let activeField = null;

    // Populate the tag list once
    tags.forEach(tag => {
        const li = document.createElement('li');
        li.textContent = tag;
        li.dataset.tag = tag;
        li.addEventListener('click', () => insertTag(tag));
        tagsList.appendChild(li);
    });

    // Attach "Insert Tag" button to all input[type="text"] and textarea
    document.querySelectorAll('.ladderseo-form-group').forEach(group => {
        const input = group.querySelector('input[type="text"], textarea');
        const insertButton = group.querySelector('.ladderseo-btn-insert-tag');

        if (input && insertButton) {
            insertButton.addEventListener('click', (e) => {
                e.stopPropagation();
                activeField = input;
                showDropdown(insertButton);
            });
        }
    });

    // Show dropdown near button
    function showDropdown(button) {
        const rect = button.getBoundingClientRect();
        dropdown.style.left = `${rect.left}px`;
        dropdown.style.display = 'block';
    }

    // Hide dropdown on outside click
    document.addEventListener('click', (e) => {
        if (!dropdown.contains(e.target)) {
            dropdown.style.display = 'none';
        }
    });

    // Insert tag at cursor position in active field
    function insertTag(tag) {
        if (!activeField) return;

        const cursorPos = activeField.selectionStart;
        const textBefore = activeField.value.substring(0, cursorPos);
        const textAfter = activeField.value.substring(cursorPos);

        // Insert tag and move cursor
        activeField.value = `${textBefore}{{${tag}}}${textAfter}`;
        activeField.selectionStart = activeField.selectionEnd = cursorPos + tag.length + 4;

        dropdown.style.display = 'none';
        activeField.focus();
    }
});
