document.addEventListener('DOMContentLoaded', function () { 
    const chartDataElement = document.getElementById('chartData');
    const chartData = JSON.parse(chartDataElement.getAttribute('data-chart-data'));
    const ctx = document.getElementById('ladderseoStats').getContext('2d');
    const myPieChart = new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: chartData.labels,
            datasets: chartData.datasets,
        },
        options: {
            responsive: true,
            cutout: '90%', // Adjust the size of the hole
            plugins: {
                legend: {
                    position: 'top',
                },
                tooltip: {
                    callbacks: {
                        label: function(tooltipItem) {
                            return `${tooltipItem.label}: ${tooltipItem.raw}%`;
                        }
                    }
                }
            }
        }
    });
});
