<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<?php
/**
 * The admin-side functionality of the plugin.
 *
 * @link       https://ladder-seo.com
 * @since      1.0.0
 *
 * @package    Ladder_SEO
 * @subpackage Ladder_SEO/admin
 */

/**
 * The view class of admin-side functionality of the plugin. It loads the required HTML file
 *
 */
class Ladder_SEO_Admin_View
{
    public $allowed_html = array();

    public function __construct()
    {
        $this->allowed_html = Ladder_SEO_Util::get_allowed_html();        
    }

    public function get_settings_form($settings, Ladder_SEO_Helper_Elements $helper, array $post_types, array $taxonomies, $posts, $terms, $post_data, $term_data, array $redirection_data, string $page_type){
        $allowed_html = $this->allowed_html;
        ob_start();
        require LADDER_SEO_PLUGIN_DIR . '/admin/partials/ladder-seo-admin-header.php';
        require LADDER_SEO_PLUGIN_DIR . '/admin/partials/ladder-seo-admin-'.$page_type.'.php';
        require LADDER_SEO_PLUGIN_DIR . '/admin/partials/ladder-seo-admin-footer.php';
        $output = ob_get_contents();
        ob_end_clean();
        return $output;
    }

    public function get_post_meta_form($settings, Ladder_SEO_Helper_Elements $helper, $post, array $data, array $schemas){
        $type = $post->post_type;
        $allowed_html = $this->allowed_html;
        ob_start();
        require LADDER_SEO_PLUGIN_DIR . '/admin/partials/meta/ladder-seo-admin-meta.php';
        $output = ob_get_contents();
        ob_end_clean();
        return $output;
    }

    public function get_taxonomy_meta_form($settings, Ladder_SEO_Helper_Elements $helper, $term, array $data, array $schemas){
        $type  = $term->taxonomy;
        $allowed_html = $this->allowed_html;
        ob_start();
        require LADDER_SEO_PLUGIN_DIR . '/admin/partials/meta/ladder-seo-admin-meta-tax.php';
        $output = ob_get_contents();
        ob_end_clean();
        return $output;
    }

}