<?php
defined( 'ABSPATH' ) || exit;
use LACI_InternalLinks\Controllers\WPILCustomTableManager;
use LACI_InternalLinks\Controllers\ExternalLinksTableController;

$stats = WPILCustomTableManager::get_latest_statistics();

?>

<div class="wrap">
    <h1><?php esc_html_e( 'Link Statistics Report', 'laci-link-cluster' ); ?></h1>

    <div style="margin-bottom: 30px;">
        <?php require LACI_INTERNAL_LINKS_PLUGIN_PATH . 'templates/dashboard/partials/update-container.php'; ?>
    </div>

    <?php
    if ( ! empty( $stats['total_posts'] ) ) :
        $table = new ExternalLinksTableController();
        $table->prepare_items();
        ?>
        <div class="laci-stats-cards">
            <!-- Total Posts Card -->
            <div class="laci-stat-card">
                <a href="<?php echo esc_url( add_query_arg( [ 'get_post_type' => 'post' ], admin_url( 'admin.php?page=laci_internal_links_dashboard' ) ) ); ?>">
                    <span class="stat-icon dashicons dashicons-admin-post"></span>
                <div class="stat-value"><?php echo esc_html( $stats['total_posts'] ); ?></div>
                    <div class="stat-label"><?php esc_html_e( 'Total Posts', 'laci-link-cluster' ); ?></div>
                </a>
            </div>

            <!-- Total Links Card -->
            <div class="laci-stat-card">
                <a href="<?php echo esc_url( add_query_arg( [ 'get_post_type' => 'link' ], admin_url( 'admin.php?page=laci_internal_links_dashboard' ) ) ); ?>">
                    <span class="stat-icon dashicons dashicons-admin-links"></span>
                <div class="stat-value"><?php echo esc_html( $stats['total_links'] ); ?></div>
                    <div class="stat-label"><?php esc_html_e( 'Total Links', 'laci-link-cluster' ); ?></div>
                </a>
            </div>

            <!-- Internal Links Card -->
            <div class="laci-stat-card">
                <a href="<?php echo esc_url( add_query_arg( [ 'get_post_type' => 'internal_links' ], admin_url( 'admin.php?page=laci_internal_links_dashboard' ) ) ); ?>">
                <span class="stat-icon dashicons dashicons-networking"></span>
                <div class="stat-value"><?php echo esc_html( $stats['total_internal_links'] ); ?></div>
                    <div class="stat-label"><?php esc_html_e( 'Internal Links', 'laci-link-cluster' ); ?></div>
                </a>
            </div>

            <!-- External Links Card -->
            <div class="laci-stat-card">
                <a href="<?php echo esc_url( add_query_arg( [ 'get_post_type' => 'external_links' ], admin_url( 'admin.php?page=laci_internal_links_dashboard' ) ) ); ?>">
                <span class="stat-icon dashicons dashicons-external"></span>
                <div class="stat-value"><?php echo esc_html( count( $stats['external_links_data'] ) ); ?></div>
                    <div class="stat-label"><?php esc_html_e( 'External Links', 'laci-link-cluster' ); ?></div>
                </a>
            </div>

            <!-- Orphaned Posts Card -->
            <div class="laci-stat-card">
                <a href="<?php echo esc_url( add_query_arg( [ 'get_post_type' => 'orphan' ], admin_url( 'admin.php?page=laci_internal_links_dashboard' ) ) ); ?>">
                <span class="stat-icon dashicons dashicons-admin-post"></span>
                <div class="stat-value"><?php echo esc_html( $stats['total_orphaned_posts'] ); ?></div>
                    <div class="stat-label"><?php esc_html_e( 'Orphaned Posts', 'laci-link-cluster' ); ?></div>
                </a>
            </div>

            <!-- Broken Links Card -->
            <div class="laci-stat-card" style="display: none;">
            <a href="<?php echo esc_url( add_query_arg( [ 'get_post_type' => 'broken_links' ], admin_url( 'admin.php?page=laci_internal_links_dashboard' ) ) ); ?>">
                <span class="stat-icon dashicons dashicons-warning"></span>
                <div class="stat-value"><?php echo esc_html( $stats['total_broken_links'] ); ?></div>
                    <div class="stat-label"><?php esc_html_e( 'Broken Links', 'laci-link-cluster' ); ?></div>
                </a>
            </div>
        </div>

        <!-- Link Distribution -->
        <div class="laci-stats-overview">
            <h2><?php esc_html_e( 'Link Distribution', 'laci-link-cluster' ); ?></h2>
            <?php
            $total_links         = $stats['total_links'];
            $internal_percentage = $total_links > 0 ? ( $stats['total_internal_links'] / $total_links ) * 100 : 0;
            ?>
            <div class="laci-link-ratio">
                <div class="internal-ratio" style="width: <?php echo esc_attr( $internal_percentage ); ?>%"></div>
            </div>
            <div class="laci-stats-summary">
                <div class="summary-item" style="background-color: #2271b1; color: #1d2327;">
                    <h2><?php esc_html_e( 'Internal Links', 'laci-link-cluster' ); ?></h2>
                    <strong><?php echo round( $internal_percentage, 1 ); ?>%</strong>
                </div>
                <div class="summary-item" style="background-color: #f0f0f1;">
                    <h2><?php esc_html_e( 'External Links', 'laci-link-cluster' ); ?></h2>
                    <strong><?php echo round( 100 - $internal_percentage, 1 ); ?>%</strong>
                </div>
            </div>
        </div>

        <!-- External Links Details -->
        <div class="laci-external-links">
            <h2><?php esc_html_e( 'Top External Links', 'laci-link-cluster' ); ?></h2>
            <?php
            // Lấy và sắp xếp external links theo phần trăm
            $external_links_data = [];
            if ( ! empty( $stats['external_links_data'] ) ) {
                foreach ( $stats['external_links_data'] as $domain => $data ) {
                    $percentage = $stats['total_external_links'] > 0
                        ? ( $data['count'] / $stats['total_external_links'] ) * 100
                        : 0;

                    $external_links_data[] = [
                        'domain'     => $domain,
                        'data'       => $data,
                        'percentage' => $percentage,
                    ];
                }

                // Sắp xếp theo phần trăm giảm dần
                usort(
                    $external_links_data,
                    function ( $a, $b ) {
                        return $b['percentage'] - $a['percentage'];
                    }
                );

                // Chỉ lấy top 10
                $external_links_data = array_slice( $external_links_data, 0, 10 );
            }
            ?>
            <table>
                <thead>
                    <tr>
                        <th><?php esc_html_e( 'Domain', 'laci-link-cluster' ); ?></th>
                        <th><?php esc_html_e( 'Total Links', 'laci-link-cluster' ); ?></th>
                        <th><?php esc_html_e( 'Percentage', 'laci-link-cluster' ); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    foreach ( $external_links_data as $item ) :
                        $domain     = $item['domain'];
                        $data       = $item['data'];
                        $percentage = $item['percentage'];
                        ?>
                        <tr>
                            <td class="domain-cell">
                                <?php echo esc_html( $domain ); ?>
                            </td>
                            <td>
                                    <?php echo esc_html( $data['count'] ); ?>
                            </td>
                            <td><?php echo esc_html( round( $percentage, 1 ) . '%' ); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Popup Templates -->
        <div id="domain-links-popup" class="laci-popup" style="display:none;">
            <h3><?php esc_html_e( 'Links Detail', 'laci-link-cluster' ); ?></h3>
            <div class="links-list">
                <table class="widefat">
                    <thead>
                        <tr>
                            <th><?php esc_html_e( 'URL', 'laci-link-cluster' ); ?></th>
                            <th><?php esc_html_e( 'Occurrences', 'laci-link-cluster' ); ?></th>
                            <th><?php esc_html_e( 'Actions', 'laci-link-cluster' ); ?></th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>

        <div id="domain-posts-popup" class="laci-popup" style="display:none;">
            <h3><?php esc_html_e( 'Posts Using This Domain', 'laci-link-cluster' ); ?></h3>
            <div class="posts-list">
                <table class="widefat">
                    <thead>
                        <tr>
                            <th><?php esc_html_e( 'Post Title', 'laci-link-cluster' ); ?></th>
                            <th><?php esc_html_e( 'Links Count', 'laci-link-cluster' ); ?></th>
                            <th><?php esc_html_e( 'Actions', 'laci-link-cluster' ); ?></th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>

        <div id="edit-url-popup" class="laci-popup" style="display:none;">
            <h3><?php esc_html_e( 'Edit URL', 'laci-link-cluster' ); ?></h3>
            <div class="edit-url-form">
                <p>
                    <label><?php esc_html_e( 'Current URL:', 'laci-link-cluster' ); ?></label>
                    <span class="current-url"></span>
                </p>
                <p>
                    <label for="new-url"><?php esc_html_e( 'New URL:', 'laci-link-cluster' ); ?></label>
                    <input type="url" id="new-url" class="widefat">
                </p>
                <div class="button-group">
                    <button class="button button-primary save-url"><?php esc_html_e( 'Save', 'laci-link-cluster' ); ?></button>
                    <button class="button cancel-edit"><?php esc_html_e( 'Cancel', 'laci-link-cluster' ); ?></button>
                </div>
            </div>
        </div>
    <?php else : ?>
        <div class="notice notice-info">
            <p><?php esc_html_e( 'No statistics available yet. Please run a scan first.', 'laci-link-cluster' ); ?></p>
        </div>
    <?php endif; ?>
</div>