<?php
defined( 'ABSPATH' ) || exit;
use LACI_InternalLinks\Controllers\LinkAssistantController;

$post_table = LinkAssistantController::get_instance();
$post_table->prepare_items();

$nonce = isset( $_REQUEST['nonce'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['nonce'] ) ) : '';
if ( ! empty( $nonce ) && ! wp_verify_nonce( $nonce, 'laci-internal-links-nonce' ) ) {
    wp_die( 'Security check' );
}

$post_id_data = isset( $_REQUEST['post_id'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['post_id'] ) ) : '';
$post_title   = get_the_title( $post_id_data );
$post_link    = get_permalink( $post_id_data );

$key_words         = get_post_meta( $post_id_data, 'laci_list_key_word', true );
$key_words_implode = is_array( $key_words ) ? implode( ',', $key_words ) : '';

$content   = '';
$editor_id = 'popup-editor';
$settings  = [
    'textarea_name' => 'popup-editor',
    'media_buttons' => true,
    'teeny'         => false,
    'quicktags'     => true,
    'tinymce'       => [
        'plugins'     => 'wordpress, wplink, wpeditimage, custom_button_add_link',
        'toolbar1'    => 'undo redo | styleselect | bold italic fontsizeselect hr alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | mediaImageLibrary  | mediaimagelibrary fullscreen shortcodeList | custom_button_add_link',
        'height'      => 180,
        'content_css' => LACI_INTERNAL_LINKS_PLUGIN_URL . 'assets/admin/css/laci-editor-style.css',
    ],
];

$taxonomy_data = get_option( 'laci_internallinks_taxonomy', 'category' );
$taxonomy_data = get_taxonomy( $taxonomy_data );

?>
<div class="laci-internal-links-popup" title="Text Editor" style="display: none;">
    <?php wp_editor( $content, $editor_id, $settings ); ?>
</div>
<div id="laci-current-data"  style="display: none;"></div>

<div class="laci-placement-assistant">
    <div class="wrap">
        <div class="laci-placement-assistant-title" data-link="<?php echo esc_attr( $post_link ); ?>" data-title="<?php echo esc_attr( $post_title ); ?>" data-id="<?php echo esc_attr( $post_id_data ); ?>" data-keywords="<?php echo esc_attr( $key_words_implode ); ?>">
            <h1><?php echo ( esc_html__( 'Link Assistant to find Link Opportunities for: ', 'laci-link-cluster' ) . esc_html( $post_title ) ); ?></h1>
        </div>
        <div>
            <?php $post_table->display(); ?>
        </div>
        <div class="laci-search-group">
            <div class="laci-search-control">
                <input type="text" class="laci-search-input-control" placeholder="key_word1, key_word2,..." style="width:100%;height:50px" data-id="<?php echo esc_html( $post_id_data ); ?>">
                <p class="laci-insert-main-key-word"><?php esc_html_e( '[ INSERT MAIN KEYWORDS FOR THE POST ]', 'laci-link-cluster' ); ?></p>
            </div>
            <button class="button laci-search-button"><?php esc_html_e( 'Search', 'laci-link-cluster' ); ?></button>
        </div>
        <div class="laci-search-text"><?php esc_html_e( 'Search Results:', 'laci-link-cluster' ); ?></div>
        <div class="laci-search-results-group">
            <div class="laci-search-results__same-category">
                <div class="laci-search-results__same-category__title">
                    <p class="laci-text-title">
                        <?php
                        // translators: %s: taxonomy label
                        echo sprintf( esc_html__( 'SAME %s / CLUSTER: IN-TEXT LINK OPPORTUNITIES', 'laci-link-cluster' ), esc_html( strtoupper( $taxonomy_data->label ) ) );
                        ?>
                    </p>
                </div>
                <div class="laci-search-results__same-category__content">
                    <?php
                    $post_id_main = isset( $_REQUEST['post_id'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['post_id'] ) ) : '';
                    //$key_word     = isset( $_REQUEST['key_word'] ) ? sanitize_text_field( $_REQUEST['key_word'] ) : '';
                    $key_word = '';
                    if ( ! empty( $post_id_main ) && empty( $key_word ) ) {
                        $key_words = get_post_meta( $post_id_main, 'laci_list_key_word', true );
                        $key_word  = is_array( $key_words ) ? implode( ',', $key_words ) : '';
                    }

                    $key_word = preg_replace( '/,+/', ',', $key_word );
                    $key_word = rtrim( $key_word, ',' );

                    $result_same_cat             = LACI_InternalLinks\Controllers\PlacementAssistantController::get_posts_with_keyword_in_same_taxonomies( $post_id_main, $key_word );
                    $result_same_cat ['post_id'] = $post_id_main;
                    $class_name                  = isset( $result_same_cat['max_pages'] ) && (int) $result_same_cat['max_pages'] > 1 ? '' : 'laci-display-none';
                    if ( ! empty( $key_word ) && ! empty( $result_same_cat['posts_data'] ) ) {
                        ob_start();
                        require LACI_INTERNAL_LINKS_PLUGIN_PATH . 'templates/placement-assistant/same-category.php';
                        $html = ob_get_contents();
                        ob_end_clean();
                        laci_kses_post_e( $html );
                    } else {
                        // translators: %s: taxonomy label
                        echo '<p class="laci-text-not-info">' . sprintf( esc_html__( 'No posts found with the keyword(s) in the same %s', 'laci-link-cluster' ), esc_html( strtolower( $taxonomy_data->label ) ) ) . '</p>';
                    }
                    ?>

                </div>
                <div class="laci-loading laci-updating-message" style="display: none;"></div>
                <div class="laci-search-results__same-category__load-more <?php echo esc_attr( $class_name ); ?>">
                    <?php if ( isset( $result_same_cat['max_pages'] ) && $result_same_cat['max_pages'] > 1 ) { ?>
                        <button class="button laci-load-more-same-category" data-post-id="<?php echo esc_attr( $post_id_main ); ?>" data-key-word="<?php echo esc_attr( $key_word ); ?>" data-max-pages="<?php echo esc_attr( $result_same_cat['max_pages'] ); ?>"><?php esc_html_e( 'Load More', 'laci-link-cluster' ); ?></button>
                    <?php } else { ?>
                        <button class="button laci-load-more-same-category" data-post-id="" data-key-word="" data-max-pages=""><?php esc_html_e( 'Load More', 'laci-link-cluster' ); ?></button>
                    <?php } ?>
                </div>
            </div>

            <div class="laci-search-results__diff-category">
                <div class="laci-search-results__diff-category__title">
                    <p class="laci-text-title">
                        
                        <?php
                        // translators: %s: taxonomy label
                        echo sprintf( esc_html__( 'OTHER %s / CLUSTER: IN-TEXT LINK OPPORTUNITIES', 'laci-link-cluster' ), esc_html( strtoupper( $taxonomy_data->label ) ) );
                        ?>
                    </p>
                </div>
                <div class="laci-search-results__diff-category__content">
                    <?php
                    $post_id_main_diff = isset( $_REQUEST['post_id'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['post_id'] ) ) : '';
                    //$key_word          = isset( $_REQUEST['key_word'] ) ? sanitize_text_field( $_REQUEST['key_word'] ) : '';

                    $key_word = '';
                    if ( ! empty( $post_id_main_diff ) && empty( $key_word ) ) {
                        $key_words = get_post_meta( $post_id_main, 'laci_list_key_word', true );
                        $key_word  = is_array( $key_words ) ? implode( ',', $key_words ) : '';
                    }

                    $key_word                    = rtrim( $key_word, ',' );
                    $key_word                    = preg_replace( '/,+/', ',', $key_word );
                    $result_diff_cat             = LACI_InternalLinks\Controllers\PlacementAssistantController::get_posts_with_keyword_in_diff_taxonomy( $post_id_main_diff, $key_word );
                    $result_diff_cat ['post_id'] = $post_id_main_diff;
                    $class_name_diff             = isset( $result_diff_cat['max_pages'] ) && (int) $result_diff_cat['max_pages'] > 1 ? '' : 'laci-display-none';
                    if ( ! empty( $key_word ) && ! empty( $result_diff_cat['posts_data'] ) ) {
                        ob_start();
                        require LACI_INTERNAL_LINKS_PLUGIN_PATH . 'templates/placement-assistant/diff-category.php';
                        $html = ob_get_contents();
                        ob_end_clean();
                        laci_kses_post_e( $html );
                    } else {
                        // translators: %s: taxonomy label
                        echo '<p class="laci-text-not-info">' . sprintf( esc_html__( 'No posts found with the keyword(s) in the same %s', 'laci-link-cluster' ), esc_html( strtolower( $taxonomy_data->label ) ) ) . '</p>';
                    }
                    ?>

                </div>
                <div class="laci-loading laci-updating-message" style="display: none;"></div>
                <div class="laci-search-results__diff-category__load-more <?php echo esc_attr( $class_name_diff ); ?>">
                    <?php if ( isset( $result_diff_cat['max_pages'] ) && $result_diff_cat['max_pages'] > 1 ) { ?>
                        <button class="button laci-load-more-diff-category" data-post-id="<?php echo esc_attr( $post_id_main_diff ); ?>" data-key-word="<?php echo esc_attr( $key_word ); ?>" data-max-pages="<?php echo esc_attr( $result_diff_cat['max_pages'] ); ?>"><?php esc_html_e( 'Load More', 'laci-link-cluster' ); ?></button>
                    <?php } else { ?>
                        <button class="button laci-load-more-diff-category" data-post-id="" data-key-word="" data-max-pages=""><?php esc_html_e( 'Load More', 'laci-link-cluster' ); ?></button>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>
