<?php
defined( 'ABSPATH' ) || exit;

use LACI_InternalLinks\Controllers\CreatePostListTableController;
use LACI_InternalLinks\Controllers\InternalLinksController;

if ( empty( $result_diff_cat ) ) {
    return;
}
$posts_data   = $result_diff_cat['posts_data'];
$post_title   = $result_diff_cat['post_title'];
$post_id_main = $result_diff_cat['post_id'];
?>

<?php
foreach ( $posts_data as $post_data ) :
    $post_id_data    = isset( $post_data['post_id'] ) ? $post_data['post_id'] : '';
    $post_title_data = isset( $post_data['title'] ) ? $post_data['title'] : '';
    $contents        = isset( $post_data['excerpts'] ) ? $post_data['excerpts'] : '';
    $edit_post_link  = get_edit_post_link( $post_id_data );
    $total_results   = isset( $post_data['total_keywords_fined'] ) ? $post_data['total_keywords_fined'] : '0';

    if ( empty( $contents ) ) {
        continue;
    }
    ?>
    <div class="laci-container-diff-cat-item laci-container-cat-item" data-id="<?php echo esc_html( $post_id_data ); ?>">
        <div class="laci-left-section">
            <div class="laci-category">
                <h3 style="margin-top:0"><?php echo esc_html( $taxonomy_data->label ); ?></h3>
                <span><?php laci_kses_post_e( CreatePostListTableController::get_hierarchical_categories( $post_id_data ) ); ?></span>
            </div>
        </div>
        <div class="laci-mid-section">
            <div class="laci-name-post" data-title="<?php echo esc_html( $post_title_data ); ?>">
                <a href="<?php echo esc_url( $edit_post_link ); ?>" target="_blank"><?php echo esc_html( $post_title_data ); ?></a>
            </div>
            <div class="laci-post-content" >
                <?php
                foreach ( $contents as $key => $content ) :
                    $style = ( 0 === $key );
                    ?>
                    <div class="laci-post-content__excerpt" data-num="<?php echo esc_html( $key ); ?>" data-current-excerpt="<?php echo esc_html( $key ); ?>" style="<?php echo esc_html( $style ); ?>">
                        <div class="laci-post-content__excerpt__content">
                            <?php laci_kses_post_e( $content ); ?>
                        </div>
                        <a class="laci-diff-cat-content-edit" href="#">[Edit &amp; Place Link]</a> | 
                        <a class="laci-add-related-box" href="#">[Add Related Box]</a>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="laci-right-section">
            <div><?php echo esc_html__( 'Outgoing Links to', 'laci-link-cluster' ) . esc_html( $post_title ); ?>: <?php echo esc_html( InternalLinksController::count_outbound_links_between_posts( $post_id_data, $post_id_main ) ); ?></div>
            <div><?php echo esc_html__( 'Outbound Internal Links:', 'laci-link-cluster' ) . esc_html( count( InternalLinksController::get_outbound_internal_links( $post_id_data ) ) ); ?></div>
            <div><?php echo esc_html__( 'Inbound Internal Links:', 'laci-link-cluster' ) . esc_html( count( InternalLinksController::get_inbound_internal_links( $post_id_data ) ) ); ?></div>
        </div>
    </div>
<?php endforeach; ?>