<?php
defined( 'ABSPATH' ) || exit;

use LACI_InternalLinks\Controllers\CreatePostListTableController;

$nonce = isset( $_REQUEST['nonce'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['nonce'] ) ) : '';
if ( ! empty( $nonce ) && ! wp_verify_nonce( $nonce, 'laci-internal-links-nonce' ) ) {
    wp_die( 'Security check' );
}

$post_list_table = CreatePostListTableController::get_instance();

$post_list_table->prepare_items();

$all_count    = $post_list_table->get_post_count_by_type();
$page_count   = $post_list_table->get_post_count_by_type( 'page' );
$post_count   = $post_list_table->get_post_count_by_type( 'post' );
$other_count  = $post_list_table->get_post_count_by_type( '' ); // Other post type
$orphan_count = $post_list_table->count_orphan_pages();

$inbound_link_entire_site_quantity_from = isset( $_GET['inbound_link_entire_site_quantity_from'] ) ? sanitize_text_field( wp_unslash( $_GET['inbound_link_entire_site_quantity_from'] ) ) : '';
$inbound_link_entire_site_quantity_to   = isset( $_GET['inbound_link_entire_site_quantity_to'] ) ? sanitize_text_field( wp_unslash( $_GET['inbound_link_entire_site_quantity_to'] ) ) : '';

$outbound_link_entire_site_quantity_from = isset( $_GET['outbound_link_entire_site_quantity_from'] ) ? sanitize_text_field( wp_unslash( $_GET['outbound_link_entire_site_quantity_from'] ) ) : '';
$outbound_link_entire_site_quantity_to   = isset( $_GET['outbound_link_entire_site_quantity_to'] ) ? sanitize_text_field( wp_unslash( $_GET['outbound_link_entire_site_quantity_to'] ) ) : '';

$inbound_links_in_category_quantity_from = isset( $_GET['inbound_links_in_category_quantity_from'] ) ? sanitize_text_field( wp_unslash( $_GET['inbound_links_in_category_quantity_from'] ) ) : '';
$inbound_links_in_category_quantity_to   = isset( $_GET['inbound_links_in_category_quantity_to'] ) ? sanitize_text_field( wp_unslash( $_GET['inbound_links_in_category_quantity_to'] ) ) : '';

$outbound_links_in_category_quantity_from = isset( $_GET['outbound_links_in_category_quantity_from'] ) ? sanitize_text_field( wp_unslash( $_GET['outbound_links_in_category_quantity_from'] ) ) : '';
$outbound_links_in_category_quantity_to   = isset( $_GET['outbound_links_in_category_quantity_to'] ) ? sanitize_text_field( wp_unslash( $_GET['outbound_links_in_category_quantity_to'] ) ) : '';

$search_value = isset( $_GET['s'] ) ? sanitize_text_field( wp_unslash( $_GET['s'] ) ) : '';

$get_post_type = isset( $_GET['get_post_type'] ) ? sanitize_text_field( wp_unslash( $_GET['get_post_type'] ) ) : 'all';
$only_orphan   = isset( $_GET['only_orphan'] ) ? sanitize_text_field( wp_unslash( $_GET['only_orphan'] ) ) : '';
?>

<div class="wrap">
    <?php require LACI_INTERNAL_LINKS_PLUGIN_PATH . 'templates/dashboard/partials/header.php'; ?>
    
    <div class="clear"></div>
    <div class="wrap-search-and-filters">
        <form method="get" class="wrap-filters laci-wrap-from">
            <input type="hidden" name="get_post_type" value="<?php echo esc_html( $get_post_type ); ?>">
            <input type="hidden" name="only_orphan" value="<?php echo esc_html( $only_orphan ); ?>">
            <input type="hidden" name="page" value="laci_internal_links_dashboard">
            <input type="hidden" name="nonce" value="<?php echo wp_kses_post( wp_create_nonce( 'laci-internal-links-nonce' ) ); ?>">
            <input type="search" id="search_id-search-input" name="s" value="<?php echo esc_html( $search_value ); ?>">
            <input type="submit" id="search-submit" class="button" value="<?php echo esc_attr__( 'Search', 'laci-link-cluster' ); ?>">
            <?php
            $taxonomy_val = get_option( 'laci_internallinks_taxonomy', 'category' );

            wp_dropdown_categories(
                [
                    'taxonomy'        => $taxonomy_val,
                    'hide_empty'      => false,
                    'name'            => 'category',
                    'id'              => 'category',
                    'show_option_all' => __( 'All Terms', 'laci-link-cluster' ),
                    'selected'        => isset( $_GET['category'] ) ? intval( $_GET['category'] ) : 0,
                    'hierarchical'    => true,
                    'value_field'     => 'term_id',
                ]
            );
            ?>
            <input type="submit" value="<?php echo esc_attr__( 'Filter', 'laci-link-cluster' ); ?>" class="button">
            <div class="clear"></div>
            <input type="hidden" name="page" value="laci_internal_links_dashboard">
            <input type="hidden" name="nonce" value="<?php echo wp_kses_post( wp_create_nonce( 'laci-internal-links-nonce' ) ); ?>">
            <div class="laci-filter-link-group">
                <div>
                    <div class="laci-filter-link-item">
                        <label class="laci-label-filter-number" for="quantity"><?php esc_html_e( 'INBOUND LINKS ENTIRE SITE', 'laci-link-cluster' ); ?></label>
                        <input class="laci-filter-link" style="width: 70px" type="number" id="quantity" name="inbound_link_entire_site_quantity_from" min="0" max="9000" value="<?php echo esc_attr( $inbound_link_entire_site_quantity_from ); ?>" placeholder="<?php echo esc_attr__( 'from', 'laci-link-cluster' ); ?>">
                        <input class="laci-filter-link"  style="width: 70px" type="number" id="quantity" name="inbound_link_entire_site_quantity_to" min="0" max="9000" value="<?php echo esc_attr( $inbound_link_entire_site_quantity_to ); ?>"  placeholder="<?php echo esc_attr__( 'to', 'laci-link-cluster' ); ?>">
    
                    </div>
                    <div class="laci-filter-link-item">
                        <label class="laci-label-filter-number" for="quantity"><?php esc_html_e( 'OUTBOUND LINKS ENTIRE SITE', 'laci-link-cluster' ); ?></label>
                        <input class="laci-filter-link" style="width: 70px" type="number" id="quantity" name="outbound_link_entire_site_quantity_from" min="0" max="9000" value="<?php echo esc_attr( $outbound_link_entire_site_quantity_from ); ?>" placeholder="<?php echo esc_attr__( 'from', 'laci-link-cluster' ); ?>">
                        <input class="laci-filter-link" style="width: 70px" type="number" id="quantity" name="outbound_link_entire_site_quantity_to" min="0" max="9000" value="<?php echo esc_attr( $outbound_link_entire_site_quantity_to ); ?>"  placeholder="<?php echo esc_attr__( 'to', 'laci-link-cluster' ); ?>">
                    </div>
                </div>
                <div>
                    <div class="laci-filter-link-item">
                        <label class="laci-label-filter-number" for="quantity"><?php esc_html_e( 'INBOUND LINKS SAME CLUSTER', 'laci-link-cluster' ); ?></label>
                        <input class="laci-filter-link" style="width: 70px" type="number" id="quantity" name="inbound_links_in_category_quantity_from" min="0" max="9000" value="<?php echo esc_attr( $inbound_links_in_category_quantity_from ); ?>"  placeholder="<?php echo esc_attr__( 'from', 'laci-link-cluster' ); ?>">
                        <input class="laci-filter-link" style="width: 70px" type="number" id="quantity" name="inbound_links_in_category_quantity_to" min="0" max="9000" value="<?php echo esc_attr( $inbound_links_in_category_quantity_to ); ?>"  placeholder="<?php echo esc_attr__( 'to', 'laci-link-cluster' ); ?>">
                    </div>
                    <div class="laci-filter-link-item">
                        <label class="laci-label-filter-number" for="quantity"><?php esc_html_e( 'OUTBOUND LINKS SAME CLUSTER', 'laci-link-cluster' ); ?></label>
                        <input class="laci-filter-link" style="width: 70px" type="number" id="quantity" name="outbound_links_in_category_quantity_from" min="0" max="9000" value="<?php echo esc_attr( $outbound_links_in_category_quantity_from ); ?>" placeholder="<?php echo esc_attr__( 'from', 'laci-link-cluster' ); ?>">
                        <input class="laci-filter-link" style="width: 70px" type="number" id="quantity" name="outbound_links_in_category_quantity_to" min="0" max="9000" value="<?php echo esc_attr( $outbound_links_in_category_quantity_to ); ?>" placeholder="<?php echo esc_attr__( 'to', 'laci-link-cluster' ); ?>">
                    </div>
                </div>
            </div>
            <div>
                <input type="submit" value="<?php echo esc_attr__( 'Filter Link', 'laci-link-cluster' ); ?>" class="button laci-filter-link-group">
                <input type="submit" value="<?php echo esc_attr__( 'Clear ALL', 'laci-link-cluster' ); ?>" class="button laci-filter-link-group-clear-all">
            </div>
        </form>
    </div>
    <div class="clear"></div>
  
    <?php require LACI_INTERNAL_LINKS_PLUGIN_PATH . 'templates/dashboard/partials/update-container.php'; ?>
   
    <div>
        <?php $post_list_table->display(); ?>
    </div>
</div>