<?php
defined( 'ABSPATH' ) || exit;

use LACI_InternalLinks\Controllers\BrokenLinksTableController;

$broken_links_table = BrokenLinksTableController::get_instance();

$broken_links_table->prepare_items();

$search_value = isset( $_GET['s'] ) ? sanitize_text_field( wp_unslash( $_GET['s'] ) ) : '';
?>

<div class="wrap">
    <?php require LACI_INTERNAL_LINKS_PLUGIN_PATH . 'templates/dashboard/partials/header.php'; ?>

    <div class="clear"></div>

    <div class="wrap-search-and-filters">
        <form method="get" class="wrap-filters laci-wrap-from">
            <input type="search" id="search_id-search-input" name="s" 
                    value="<?php echo esc_html( $search_value ); ?>" 
                    placeholder="<?php esc_attr_e( 'Search URLs...', 'laci-link-cluster' ); ?>">
            <input type="submit" id="search-submit" class="button" 
                    value="<?php echo esc_attr__( 'Search', 'laci-link-cluster' ); ?>">

            <input type="hidden" name="page" value="laci_internal_links_dashboard">
            <input type="hidden" name="nonce" value="<?php echo wp_kses_post( wp_create_nonce( 'laci-internal-links-nonce' ) ); ?>">
            <input type="hidden" name="get_post_type" value="broken_links">

            <?php if ( ! empty( $search_value ) ) : ?>
                <div class="search-results-info">
                    <?php
                    printf(
                        /* translators: %s: search keywords */
                        esc_html__( 'Search Results for: %s', 'laci-link-cluster' ),
                        '<span>' . esc_html( $search_value ) . '</span>'
                    );
                    ?>
                    <a href="<?php echo esc_url( remove_query_arg( 's' ) ); ?>" class="clear-search">
                        <?php esc_html_e( 'Clear Search', 'laci-link-cluster' ); ?>
                    </a>
                </div>
            <?php endif; ?>
        </form>
    </div>

    <div class="clear"></div>

    <?php require LACI_INTERNAL_LINKS_PLUGIN_PATH . 'templates/dashboard/partials/update-container.php'; ?>

    <div>
        <?php $broken_links_table->display(); ?>
    </div>
</div>