<?php
defined( 'ABSPATH' ) || exit;

// Lấy dữ liệu taxonomy từ tùy chọn
$taxonomy_option = get_option( 'laci_internallinks_taxonomy', 'category' );
$taxonomy_data   = get_taxonomy( $taxonomy_option );

// Lấy danh sách các term liên quan đến bài viết
$terms = get_the_term_list( $post_id, $taxonomy_data->name, '', ', ', '' );
?>

<h3><?php echo esc_html__( 'Information for: ', 'laci-link-cluster' ) . esc_html( $post_title ); ?></h3>

<?php
if ( 'link_back_to_category' === $link_type ) {
    ?>
    <table>
        <thead>
            <tr>
                <th><?php echo esc_html( $taxonomy_data->label ); ?></th>
                <th><?php esc_html_e( 'Linked', 'laci-link-cluster' ); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ( $links as $item ) : ?>
                <tr>
                    <td><?php echo wp_kses_post( $terms ); ?></td>
                    <td><?php echo wp_kses_post( $item['linked'] ); ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php
} elseif ( 'external' === $link_type ) {
    ?>
    <div class="laci-popup-content">
        <h3><?php esc_html_e( 'External Links Details', 'laci-link-cluster' ); ?></h3>
        <?php
        $external_links = LACI_InternalLinks\Controllers\InternalLinksController::get_external_links( $post_id );
        if ( ! empty( $external_links['grouped_by_domain'] ) ) {
            foreach ( $external_links['grouped_by_domain'] as $domain_data ) :
                ?>
                <div class="laci-domain-group">
                    <h4><?php echo esc_html( $domain_data['domain'] ); ?> 
                        (<?php echo esc_html( $domain_data['total_links'] ); ?> <?php esc_html_e( 'links', 'laci-link-cluster' ); ?>)</h4>
                    <ul>
                    <?php foreach ( $domain_data['links'] as $link ) : ?>
                        <li>
                            <div class="laci-link-details">
                                <p><strong><?php esc_html_e( 'URL:', 'laci-link-cluster' ); ?></strong> 
                                    <a href="<?php echo esc_url( $link['url'] ); ?>" target="_blank"><?php echo esc_html( $link['url'] ); ?></a></p>
                                <p><strong><?php esc_html_e( 'Anchor Text:', 'laci-link-cluster' ); ?></strong> 
                                    <?php echo esc_html( $link['anchor_text'] ); ?></p>
                                <p><strong><?php esc_html_e( 'Attributes:', 'laci-link-cluster' ); ?></strong>
                                    <?php
                                    $attributes = [];
                                    if ( $link['attributes']['nofollow'] ) {
                                        $attributes[] = 'nofollow';
                                    }
                                    if ( $link['attributes']['sponsored'] ) {
                                        $attributes[] = 'sponsored';
                                    }
                                    if ( $link['attributes']['ugc'] ) {
                                        $attributes[] = 'ugc';
                                    }
                                    echo esc_html( implode( ', ', $attributes ) );
                                    ?>
                                </p>
                            </div>
                        </li>
                    <?php endforeach; ?>
                    </ul>
                </div>
                <?php
            endforeach;
        } else {
            ?>
            <p><?php esc_html_e( 'No external links found.', 'laci-link-cluster' ); ?></p>
        <?php } ?>
    </div>
    <?php
} else {
    ?>
    <table>
        <thead>
            <tr>
                <th><?php esc_html_e( 'Title', 'laci-link-cluster' ); ?></th>
                <th><?php esc_html_e( 'Type', 'laci-link-cluster' ); ?></th>
                <th><?php echo esc_html( $taxonomy_data->label ); ?></th>
                <th><?php esc_html_e( 'Anchor Text', 'laci-link-cluster' ); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ( $links as $item ) : ?>
                <tr>
                    <td><a href="<?php echo esc_url( get_edit_post_link( $item['ID'] ) ); ?>"><?php echo esc_html( $item['title'] ); ?></a></td>
                    <td><?php echo esc_html( ucfirst( $item['type'] ) ); ?></td>
                    <td><?php echo wp_kses_post( $terms ); ?></td>
                    <td><?php echo wp_kses_post( $item['anchor_text'] ); ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php
}
?>