<?php
defined( 'ABSPATH' ) || exit;

use LACI_InternalLinks\Controllers\CreatePostListTableController;
use LACI_InternalLinks\Controllers\WPILCustomTableManager;

$nonce = isset( $_REQUEST['nonce'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['nonce'] ) ) : '';
if ( ! empty( $nonce ) && ! wp_verify_nonce( $nonce, 'laci-internal-links-nonce' ) ) {
    wp_die( 'Security check' );
}

$post_list_table = CreatePostListTableController::get_instance();
$stats           = WPILCustomTableManager::get_latest_statistics();

$all_count    = $post_list_table->get_post_count_by_type();
$page_count   = $post_list_table->get_post_count_by_type( 'page' );
$post_count   = $post_list_table->get_post_count_by_type( 'post' );
$other_count  = $post_list_table->get_post_count_by_type( '' ); // Other post type
$orphan_count = $post_list_table->count_orphan_pages();

// Lấy số lượng external links và broken links từ statistics
$external_links_count = ! empty( $stats['external_links_data'] ) ? count( $stats['external_links_data'] ) : 0;
$broken_links_count   = ! empty( $stats['broken_links_data'] ) ? count( $stats['broken_links_data'] ) : 0;

$search_value  = isset( $_GET['s'] ) ? sanitize_text_field( wp_unslash( $_GET['s'] ) ) : '';
$get_post_type = isset( $_GET['get_post_type'] ) ? sanitize_text_field( wp_unslash( $_GET['get_post_type'] ) ) : 'all';
$only_orphan   = isset( $_GET['only_orphan'] ) ? sanitize_text_field( wp_unslash( $_GET['only_orphan'] ) ) : '';

// Thêm class cho tab hiện tại
$current_tab = $get_post_type;
?>

<div class="wrap-top-nav">
    <ul class="subsubsub" style="margin-bottom:10px">
        <?php
        $links = [
            'all'            => [ esc_html__( 'All', 'laci-link-cluster' ), $all_count ],
            'page'           => [ esc_html__( 'Only Page', 'laci-link-cluster' ), $page_count ],
            'post'           => [ esc_html__( 'Only Posts', 'laci-link-cluster' ), $post_count ],
            'other'          => [ esc_html__( 'Other Posts Type', 'laci-link-cluster' ), $other_count ],
            'orphan'         => [ esc_html__( 'Orphan Posts', 'laci-link-cluster' ), $orphan_count ],
            'external_links' => [ esc_html__( 'External Links', 'laci-link-cluster' ), $external_links_count ],
            //'broken_links'   => [ esc_html__( 'Broken Links', 'laci-link-cluster' ), $broken_links_count ],
        ];

        $last_key = array_key_last( $links );

        foreach ( $links as $key => $label_count ) {
            $class = '';

            if ( $current_tab === $key || ( $only_orphan && 'orphan' === $key ) ) {
                $class = 'class="current"';
            }

            if ( in_array( $key, [ 'external_links', 'broken_links' ] ) ) {
                $href = add_query_arg(
                    [
                        'get_post_type' => $key,
                        'page'          => 'laci_internal_links_dashboard',
                    ]
                );

                //tôi muốn trong href không có only_orphan, orderby, order
                $href = remove_query_arg( [ 'category', 'only_orphan', 'orderby', 'order', 'inbound_link_entire_site_quantity_from', 'inbound_link_entire_site_quantity_to', 'outbound_link_entire_site_quantity_from', 'outbound_link_entire_site_quantity_to', 'inbound_links_in_category_quantity_from', 'inbound_links_in_category_quantity_to', 'outbound_links_in_category_quantity_from', 'outbound_links_in_category_quantity_to' ], $href );

            } else {
                $href = add_query_arg(
                    array_merge(
                        $_REQUEST,
                        [
                            'get_post_type' => 'orphan' !== $key ? $key : '',
                            'only_orphan'   => 'orphan' === $key ? '1' : '',
                            'page'          => 'laci_internal_links_dashboard',
                        ]
                    )
                );
            }

            echo '<li><a href="' . esc_url( $href ) . '" ' . wp_kses_post( $class ) . '>'
                . esc_html( $label_count[0] )
                . ' <span class="count">(' . esc_html( $label_count[1] ) . ')</span></a>'
                . ( $key !== $last_key ? ' | ' : '' )
                . '</li>';
        }
        ?>
    </ul>
</div>